package com.sinosoftgz.starter.mail.core.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author: Roney
 * @date: 2022-05-09 14:16
 * @description: 邮件平台
 */
public enum MailPlatformType {
    MOCK("MOCK", "MOCK"),
    /**
     * spring boot mail
     */
    SPRING_BOOT_MAIL("SPRING_BOOT_MAIL", "spring boot mail"),
    MICROSOFT("MICROSOFT", "微软邮件平台"),
    ALIBABA("ALIBABA", "阿里邮件平台"),
    TENCENT("TENCENT", "腾讯邮件平台"),
    NET_EASE("NET_EASE", "网易邮件平台"),
    OTHER("OTHER", "其他邮件平台"),
    ;
    public static Map<String, MailPlatformType> mailPlatformTypeMap = Maps.newConcurrentMap();


    static {
        mailPlatformTypeMap.put(MOCK.getType(), MOCK);
        mailPlatformTypeMap.put(SPRING_BOOT_MAIL.getType(), SPRING_BOOT_MAIL);
        mailPlatformTypeMap.put(MICROSOFT.getType(), MICROSOFT);
        mailPlatformTypeMap.put(ALIBABA.getType(), ALIBABA);
        mailPlatformTypeMap.put(TENCENT.getType(), TENCENT);
        mailPlatformTypeMap.put(NET_EASE.getType(), NET_EASE);
        mailPlatformTypeMap.put(OTHER.getType(), OTHER);
    }

    /**
     * 类型
     */
    private String type;
    /**
     * 描述
     */
    private String remark;

    MailPlatformType(String type, String remark) {
        this.type = type;
        this.remark = remark;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
