package com.sinosoftgz.starter.mail.core.handler;

import com.sinosoftgz.starter.mail.core.request.JavaMailClientReq;
import com.sinosoftgz.starter.spring.utils.handler.AbstractHandler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author: Roney
 * @date: 2022-05-09 14:29
 * @description: AbstractMailHandler
 */
public abstract class AbstractMailHandler extends AbstractHandler implements MailHandler {

    /**
     * 测试策略模式
     */
    public abstract void testStrategyPattern();

    /**
     * 邮件发送
     *
     * @param javaMailClientReq
     * @return
     */
    @Override
    public abstract boolean send(JavaMailClientReq javaMailClientReq);

    /**
     * 校验参数信息
     *
     * @param javaMailClientReq
     */
    public void checkJavaMailClient(JavaMailClientReq javaMailClientReq) {
        Assert.notNull(javaMailClientReq, "邮件发送统一请求对象不能为空");
        Assert.notNull(javaMailClientReq.getRecipientTos(), "收件人列表不能为空");
        if (!CollectionUtils.isEmpty(javaMailClientReq.getImages())) {
            AtomicBoolean imageDataNullFlag = new AtomicBoolean(false);
            javaMailClientReq.getImages().parallelStream().forEach(image -> {
                boolean checkDataFlag = !StringUtils.hasLength(image.getBase64Str()) && (null == image.getData() || image.getData().length == 0);
                if (checkDataFlag) {
                    imageDataNullFlag.set(true);

                }
            });
            if (imageDataNullFlag.get()) {
                throw new IllegalArgumentException("邮件图片信息存在空");
            }
        }

        if (!CollectionUtils.isEmpty(javaMailClientReq.getAttachments())) {
            AtomicBoolean fileDataNullFlag = new AtomicBoolean(false);
            javaMailClientReq.getAttachments().parallelStream().forEach(attachment -> {
                boolean checkDataFlag = !StringUtils.hasLength(attachment.getBase64Str()) && (null == attachment.getData() || attachment.getData().length == 0);
                if (checkDataFlag) {
                    fileDataNullFlag.set(true);
                }
            });
            if (fileDataNullFlag.get()) {
                throw new IllegalArgumentException("邮件附件信息存在空");
            }
        }
    }
}
