package com.sinosoftgz.starter.mail.core.handler;


import com.google.common.collect.Maps;

import com.sinosoftgz.starter.mail.core.enums.MailPlatformType;
import com.sinosoftgz.starter.mail.core.handler.annotation.MailHandlerType;
import com.sinosoftgz.starter.spring.utils.content.ClassResourceLoaderAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * Created by Roney on 2021/5/27 14:26.
 */
@Component
public class MailHandlerProcessor implements BeanFactoryPostProcessor {
    /**
     * 指定扫描处理器的包，不做配置化，减少复杂度，只认这个包下的实现类
     */
    private static final String HANDLER_PACKAGE = "com.sinosoftgz.starter.mail.core.handler";

    /**
     * 扫描@HandlerType，初始化HandlerContext，将其注册到spring容器
     *
     * @param beanFactory bean工厂
     * @see MailHandlerType
     * @see MailHandlerContext
     */
    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Map<MailPlatformType, Class> handlerMap = Maps.newConcurrentMap();
        ClassResourceLoaderAware.scan(HANDLER_PACKAGE, MailHandlerType.class).forEach(clazz -> {
            MailPlatformType type = clazz.getAnnotation(MailHandlerType.class).value();
            handlerMap.put(type, clazz);
        });
        MailHandlerContext context = new MailHandlerContext(handlerMap);
        beanFactory.registerSingleton(MailHandlerContext.class.getName(), context);
    }
}
