package com.sinosoftgz.starter.mail.core.handler.biz;

import com.sinosoftgz.starter.mail.core.enums.MailPlatformType;
import com.sinosoftgz.starter.mail.core.handler.AbstractMailHandler;
import com.sinosoftgz.starter.mail.core.request.JavaMailClientReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;


/**
 * @author: Roney
 * @date: 2022-05-09 14:37
 * @description: DefaultMailHandler
 */

@Component
@Slf4j
public class DefaultMailHandler extends AbstractMailHandler {

    @Override
    public void testStrategyPattern() {
        log.debug("DefaultMailHandler");
    }

    @Override
    public boolean send(JavaMailClientReq javaMailClientReq) {
        checkJavaMailClient(javaMailClientReq);
        return false;
    }


}
