package com.sinosoftgz.starter.mail.core.handler.biz;

import com.sinosoftgz.starter.mail.core.enums.MailPlatformType;
import com.sinosoftgz.starter.mail.core.handler.AbstractMailHandler;
import com.sinosoftgz.starter.mail.core.handler.annotation.MailHandlerType;
import com.sinosoftgz.starter.mail.core.request.JavaMailClientReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;


/**
 * @author: Roney
 * @date: 2022-05-09 14:37
 * @description: MockMailHandler
 * Mock实现，业务方不需要在写if判断是否开关打开
 */

@Component
@MailHandlerType(MailPlatformType.MOCK)
@Slf4j
public class MockMailHandler extends DefaultMailHandler {

    @Override
    public void testStrategyPattern() {
        log.debug("MockMailHandler");
    }

    @Override
    public boolean send(JavaMailClientReq javaMailClientReq) {
        checkJavaMailClient(javaMailClientReq);
        log.info("使用Mock实现，默认发送成功");
        return true;
    }


}
