package com.sinosoftgz.starter.mail.core.properties;

import com.sinosoftgz.starter.mail.core.constant.MailConstants;
import com.sinosoftgz.starter.mail.core.enums.MailPlatformType;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author: Roney
 * @date: 2022-05-09 14:27
 * @description: 邮件平台配置
 */
@ConfigurationProperties(prefix = MailPlatformProperties.MAIL_PLATFORM_PREFIX)
@Data
public class MailPlatformProperties {

    public static final String MAIL_PLATFORM_PREFIX = "mail.platform";

    /**
     * 邮件平台类型，默认是MOCK
     */
    private String type = MailPlatformType.MOCK.getType();

    /**
     * 发送html，嵌入图片位置的content前缀
     */
    private String mailImageContentIdPrefix = MailConstants.MAIL_IMAGE_CONTENT_ID_PREFIX;
}
