package com.sinosoftgz.starter.mail.core.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author: Roney
 * @date: 2022-05-09 14:51
 * @description: FileData
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class FileData {
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 文件字节流(建议rpc使用)
     * 不使用file避免协议和安全问题
     */
    private byte[] data;

    /**
     * base64文件流(建议http使用)
     * http接口，前端不好转byte数组，因此提供base64字符串
     */
    private String base64Str;

    public FileData(String fileName, byte[] data) {
        this.fileName = fileName;
        this.data = data;
    }

    public FileData(String fileName, String base64Str) {
        this.fileName = fileName;
        this.base64Str = base64Str;
    }
}
