package com.sinosoftgz.starter.mail.core.request;

import com.sinosoftgz.starter.mail.core.enums.MailBodyType;
import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * @author: Roney
 * @date: 2022-05-09 10:51
 * @description: 邮件发送请求对象
 */
@Data
@Builder
public class MailSendReq implements Serializable {

    /**
     * 邮件主题
     */
    private String subject;

    /**
     * 邮件内容
     */
    private String content;

    /**
     * 邮件接收方，可多人
     */
    @NotEmpty(message = "邮件接收人不能为空")
    private List<String> recipientTos;

    /**
     * 抄送人
     */
    private List<String> recipientCc;

    /**
     * 密送人
     */
    private List<String> recipientBcc;

    /**
     * 文件
     */
    private List<MailFileReq> files;

    /**
     * 图片
     */
    private List<MailImageReq> images;

    /**
     * 邮件类型 文本/HTML
     */
    private MailBodyType mailBodyType;
}
