/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.mail.core.api.impl;

import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.mail.core.biz.MailSendBiz;
import com.sinosoftgz.starter.mail.core.request.MailSendReq;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mail/send"})
public class MailSendApiRestController {
    private static final Logger log = LoggerFactory.getLogger(MailSendApiRestController.class);
    @Resource
    MailSendBiz mailSendBiz;

    @PostMapping(value={"/simple"})
    public BaseResponse sendSimpleMail(@RequestParam(name="recipientTo", required=true) String recipientTo, String subject, String content) {
        return BaseResponse.ok((Object)this.mailSendBiz.sendSimpleMail(recipientTo, subject, content));
    }

    @PostMapping(value={"/html"})
    public BaseResponse sendHtmlMail(@RequestParam(name="recipientTo", required=true) String recipientTo, String subject, String content) {
        return BaseResponse.ok((Object)this.mailSendBiz.sendHtmlMail(recipientTo, subject, content));
    }

    @PostMapping(value={""})
    public BaseResponse sendMail(BaseRequest<MailSendReq> mailSendReq) {
        return BaseResponse.ok((Object)this.mailSendBiz.sendMail(mailSendReq));
    }

    @PostMapping(value={"/batch"})
    public BaseResponse batchSendMail(BaseRequest<List<MailSendReq>> mailSendReqs) {
        return BaseResponse.ok((Object)this.mailSendBiz.batchSendMail(mailSendReqs));
    }
}

