/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.mail.core.biz.impl;

import com.sinosoftgz.global.common.request.BaseRequest;
import com.sinosoftgz.starter.mail.core.biz.MailSendBiz;
import com.sinosoftgz.starter.mail.core.enums.MailBodyType;
import com.sinosoftgz.starter.mail.core.enums.MailPlatformType;
import com.sinosoftgz.starter.mail.core.handler.AbstractMailHandler;
import com.sinosoftgz.starter.mail.core.handler.MailHandlerContext;
import com.sinosoftgz.starter.mail.core.properties.MailPlatformProperties;
import com.sinosoftgz.starter.mail.core.request.JavaMailClientReq;
import com.sinosoftgz.starter.mail.core.request.MailSendReq;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class MailSendBizImpl
implements MailSendBiz {
    private static final Logger log = LoggerFactory.getLogger(MailSendBizImpl.class);
    @Resource
    MailHandlerContext mailHandlerContext;
    @Autowired
    MailPlatformProperties mailPlatformProperties;

    @Override
    public boolean sendSimpleMail(String recipientTo, String subject, String content) {
        this.checkRecipientTo(recipientTo);
        try {
            AbstractMailHandler handler = this.getAbstractMailHandler();
            JavaMailClientReq javaMailClientReq = new JavaMailClientReq.JavaMailClientReqBuilder().subject(subject).content(content).recipientTos(Arrays.asList(recipientTo)).mailBodyType(MailBodyType.Text).mailPlatformType(this.getMailPlatformType().getType()).build();
            return handler.send(javaMailClientReq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean sendHtmlMail(String recipientTo, String subject, String content) {
        this.checkRecipientTo(recipientTo);
        try {
            AbstractMailHandler handler = this.getAbstractMailHandler();
            JavaMailClientReq javaMailClientReq = new JavaMailClientReq.JavaMailClientReqBuilder().subject(subject).content(content).recipientTos(Arrays.asList(recipientTo)).mailBodyType(MailBodyType.HTML).mailPlatformType(this.getMailPlatformType().getType()).build();
            return handler.send(javaMailClientReq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean sendMail(BaseRequest<MailSendReq> mailSendReq) {
        this.checkMailSendReq(mailSendReq);
        try {
            AbstractMailHandler handler = this.getAbstractMailHandler();
            MailSendReq mailSendReqReq = (MailSendReq)mailSendReq.getData();
            MailBodyType mailBodyType = MailBodyType.Text;
            if (!Objects.isNull((Object)mailSendReqReq.getMailBodyType())) {
                mailBodyType = mailSendReqReq.getMailBodyType();
            }
            JavaMailClientReq javaMailClientReq = new JavaMailClientReq.JavaMailClientReqBuilder().subject(mailSendReqReq.getSubject()).content(mailSendReqReq.getContent()).recipientTos(mailSendReqReq.getRecipientTos()).recipientCc(mailSendReqReq.getRecipientCc()).recipientBcc(mailSendReqReq.getRecipientBcc()).attachments(mailSendReqReq.getFiles()).images(mailSendReqReq.getImages()).mailBodyType(mailBodyType).mailPlatformType(this.getMailPlatformType().getType()).build();
            return handler.send(javaMailClientReq);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    private void checkMailSendReq(BaseRequest<MailSendReq> mailSendReq) {
        Assert.notNull(mailSendReq, (String)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)mailSendReq.getData(), (String)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(((MailSendReq)mailSendReq.getData()).getRecipientTos(), (String)"\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        if (!CollectionUtils.isEmpty(((MailSendReq)mailSendReq.getData()).getImages())) {
            AtomicBoolean imageDataNullFlag = new AtomicBoolean(false);
            ((MailSendReq)mailSendReq.getData()).getImages().parallelStream().forEach(image -> {
                boolean checkDataFlag;
                boolean bl = checkDataFlag = !StringUtils.hasLength((String)image.getBase64Str()) && (null == image.getData() || image.getData().length == 0);
                if (checkDataFlag) {
                    imageDataNullFlag.set(true);
                }
            });
            if (imageDataNullFlag.get()) {
                throw new IllegalArgumentException("\u90ae\u4ef6\u56fe\u7247\u4fe1\u606f\u5b58\u5728\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty(((MailSendReq)mailSendReq.getData()).getFiles())) {
            AtomicBoolean fileDataNullFlag = new AtomicBoolean(false);
            ((MailSendReq)mailSendReq.getData()).getFiles().parallelStream().forEach(attachment -> {
                boolean checkDataFlag;
                boolean bl = checkDataFlag = !StringUtils.hasLength((String)attachment.getBase64Str()) && (null == attachment.getData() || attachment.getData().length == 0);
                if (checkDataFlag) {
                    fileDataNullFlag.set(true);
                }
            });
            if (fileDataNullFlag.get()) {
                throw new IllegalArgumentException("\u90ae\u4ef6\u9644\u4ef6\u4fe1\u606f\u5b58\u5728\u7a7a");
            }
        }
    }

    @Override
    public boolean batchSendMail(BaseRequest<List<MailSendReq>> mailSendReqs) {
        Assert.notNull(mailSendReqs, (String)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)((Collection)mailSendReqs.getData()), (String)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            List mailSendReqList = (List)mailSendReqs.getData();
            if (!CollectionUtils.isEmpty((Collection)mailSendReqList)) {
                mailSendReqList.parallelStream().forEach(mailSendReq -> this.sendMail((BaseRequest<MailSendReq>)BaseRequest.simple((Object)mailSendReq)));
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }

    private void checkRecipientTo(String recipientTo) {
        Assert.notNull((Object)recipientTo, (String)"\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private AbstractMailHandler getAbstractMailHandler() {
        return (AbstractMailHandler)this.mailHandlerContext.getInstance(this.getMailPlatformType());
    }

    private MailPlatformType getMailPlatformType() {
        String type = this.mailPlatformProperties.getType();
        MailPlatformType mailPlatformType = MailPlatformType.MOCK;
        if (StringUtils.hasLength((String)type) && !Objects.isNull((Object)MailPlatformType.mailPlatformTypeMap.get(type))) {
            mailPlatformType = MailPlatformType.mailPlatformTypeMap.get(type);
        }
        return mailPlatformType;
    }
}

