/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.mail.core.handler;

import com.google.common.collect.Maps;
import com.sinosoftgz.starter.mail.core.enums.MailPlatformType;
import com.sinosoftgz.starter.mail.core.handler.MailHandlerContext;
import com.sinosoftgz.starter.mail.core.handler.annotation.MailHandlerType;
import com.sinosoftgz.starter.spring.utils.content.ClassResourceLoaderAware;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class MailHandlerProcessor
implements BeanFactoryPostProcessor {
    private static final String HANDLER_PACKAGE = "com.sinosoftgz.starter.mail.core.handler";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConcurrentMap handlerMap = Maps.newConcurrentMap();
        ClassResourceLoaderAware.scan((String)HANDLER_PACKAGE, (Class[])new Class[]{MailHandlerType.class}).forEach(clazz -> {
            MailPlatformType type = clazz.getAnnotation(MailHandlerType.class).value();
            handlerMap.put(type, clazz);
        });
        MailHandlerContext context = new MailHandlerContext(handlerMap);
        beanFactory.registerSingleton(MailHandlerContext.class.getName(), (Object)context);
    }
}

