/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.mail.core.request;

import com.sinosoftgz.starter.mail.core.enums.MailBodyType;
import com.sinosoftgz.starter.mail.core.request.FileData;
import com.sinosoftgz.starter.mail.core.request.MailFileReq;
import com.sinosoftgz.starter.mail.core.request.MailImageReq;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.springframework.util.CollectionUtils;

public class JavaMailClientReq
implements Serializable {
    private String mailPlatformType;
    private final String subject;
    @NotEmpty(message="\u6536\u4ef6\u4eba\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a")
    private final @NotEmpty(message="\u6536\u4ef6\u4eba\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a") List<String> recipientTos;
    private final List<String> recipientCc;
    private final List<String> recipientBcc;
    private final List<FileData> attachments;
    private final List<FileData> images;
    private final MailBodyType mailBodyType;
    private final String content;

    private JavaMailClientReq(JavaMailClientReqBuilder builder) {
        this.mailPlatformType = builder.mailPlatformType;
        this.subject = builder.subject;
        this.recipientTos = builder.recipientTos;
        this.recipientCc = builder.recipientCc;
        this.recipientBcc = builder.recipientBcc;
        this.attachments = builder.attachments;
        this.images = builder.images;
        this.mailBodyType = builder.mailBodyType;
        this.content = builder.content;
    }

    public String getMailPlatformType() {
        return this.mailPlatformType;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<String> getRecipientTos() {
        return this.recipientTos;
    }

    public List<String> getRecipientCc() {
        return this.recipientCc;
    }

    public List<String> getRecipientBcc() {
        return this.recipientBcc;
    }

    public List<FileData> getAttachments() {
        return this.attachments;
    }

    public List<FileData> getImages() {
        return this.images;
    }

    public MailBodyType getMailBodyType() {
        return this.mailBodyType;
    }

    public String getContent() {
        return this.content;
    }

    public void setMailPlatformType(String mailPlatformType) {
        this.mailPlatformType = mailPlatformType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaMailClientReq)) {
            return false;
        }
        JavaMailClientReq other = (JavaMailClientReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mailPlatformType = this.getMailPlatformType();
        String other$mailPlatformType = other.getMailPlatformType();
        if (this$mailPlatformType == null ? other$mailPlatformType != null : !this$mailPlatformType.equals(other$mailPlatformType)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        List<String> this$recipientTos = this.getRecipientTos();
        List<String> other$recipientTos = other.getRecipientTos();
        if (this$recipientTos == null ? other$recipientTos != null : !((Object)this$recipientTos).equals(other$recipientTos)) {
            return false;
        }
        List<String> this$recipientCc = this.getRecipientCc();
        List<String> other$recipientCc = other.getRecipientCc();
        if (this$recipientCc == null ? other$recipientCc != null : !((Object)this$recipientCc).equals(other$recipientCc)) {
            return false;
        }
        List<String> this$recipientBcc = this.getRecipientBcc();
        List<String> other$recipientBcc = other.getRecipientBcc();
        if (this$recipientBcc == null ? other$recipientBcc != null : !((Object)this$recipientBcc).equals(other$recipientBcc)) {
            return false;
        }
        List<FileData> this$attachments = this.getAttachments();
        List<FileData> other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        List<FileData> this$images = this.getImages();
        List<FileData> other$images = other.getImages();
        if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
            return false;
        }
        MailBodyType this$mailBodyType = this.getMailBodyType();
        MailBodyType other$mailBodyType = other.getMailBodyType();
        if (this$mailBodyType == null ? other$mailBodyType != null : !((Object)((Object)this$mailBodyType)).equals((Object)other$mailBodyType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaMailClientReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mailPlatformType = this.getMailPlatformType();
        result = result * 59 + ($mailPlatformType == null ? 43 : $mailPlatformType.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        List<String> $recipientTos = this.getRecipientTos();
        result = result * 59 + ($recipientTos == null ? 43 : ((Object)$recipientTos).hashCode());
        List<String> $recipientCc = this.getRecipientCc();
        result = result * 59 + ($recipientCc == null ? 43 : ((Object)$recipientCc).hashCode());
        List<String> $recipientBcc = this.getRecipientBcc();
        result = result * 59 + ($recipientBcc == null ? 43 : ((Object)$recipientBcc).hashCode());
        List<FileData> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        List<FileData> $images = this.getImages();
        result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
        MailBodyType $mailBodyType = this.getMailBodyType();
        result = result * 59 + ($mailBodyType == null ? 43 : ((Object)((Object)$mailBodyType)).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "JavaMailClientReq(mailPlatformType=" + this.getMailPlatformType() + ", subject=" + this.getSubject() + ", recipientTos=" + this.getRecipientTos() + ", recipientCc=" + this.getRecipientCc() + ", recipientBcc=" + this.getRecipientBcc() + ", attachments=" + this.getAttachments() + ", images=" + this.getImages() + ", mailBodyType=" + (Object)((Object)this.getMailBodyType()) + ", content=" + this.getContent() + ")";
    }

    public static class JavaMailClientReqBuilder {
        private String mailPlatformType = "";
        private String subject = "";
        private List<String> recipientTos = new ArrayList<String>(1);
        private List<String> recipientCc = new ArrayList<String>(0);
        private List<String> recipientBcc = new ArrayList<String>(0);
        private List<FileData> attachments = new ArrayList<FileData>(0);
        private List<FileData> images = new ArrayList<FileData>(0);
        private MailBodyType mailBodyType = MailBodyType.Text;
        private String content = "";

        public JavaMailClientReqBuilder mailPlatformType(String mailPlatformType) {
            this.mailPlatformType = mailPlatformType;
            return this;
        }

        public JavaMailClientReqBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public JavaMailClientReqBuilder recipientTos(List<String> recipientTos) {
            this.recipientTos = recipientTos;
            return this;
        }

        public JavaMailClientReqBuilder recipientCc(List<String> recipientCc) {
            this.recipientCc = recipientCc;
            return this;
        }

        public JavaMailClientReqBuilder recipientBcc(List<String> recipientBcc) {
            this.recipientBcc = recipientBcc;
            return this;
        }

        public JavaMailClientReqBuilder attachments(List<MailFileReq> mailFileReqs) {
            if (!CollectionUtils.isEmpty(mailFileReqs)) {
                this.attachments.addAll(this.MailFileReqToFileData(mailFileReqs));
            }
            return this;
        }

        private List<FileData> MailFileReqToFileData(List<MailFileReq> mailFileReqs) {
            ArrayList<FileData> fileDatas = new ArrayList<FileData>();
            for (MailFileReq mailFileReq : mailFileReqs) {
                if (mailFileReq == null) continue;
                FileData data = new FileData(mailFileReq.getFileName(), mailFileReq.getData(), mailFileReq.getBase64Str());
                fileDatas.add(data);
            }
            return fileDatas;
        }

        public JavaMailClientReqBuilder images(List<MailImageReq> mailImageReqs) {
            if (!CollectionUtils.isEmpty(mailImageReqs)) {
                this.images.addAll(this.MailImageReqToFileData(mailImageReqs));
            }
            return this;
        }

        private List<FileData> MailImageReqToFileData(List<MailImageReq> mailImageReqs) {
            ArrayList<FileData> fileDatas = new ArrayList<FileData>();
            for (MailImageReq mailImageReq : mailImageReqs) {
                if (mailImageReq == null) continue;
                FileData data = new FileData(mailImageReq.getFileName(), mailImageReq.getData(), mailImageReq.getBase64Str());
                fileDatas.add(data);
            }
            return fileDatas;
        }

        public JavaMailClientReqBuilder mailBodyType(MailBodyType mailBodyType) {
            this.mailBodyType = mailBodyType;
            return this;
        }

        public JavaMailClientReqBuilder content(String content) {
            this.content = content;
            return this;
        }

        public JavaMailClientReq build() {
            return new JavaMailClientReq(this);
        }
    }
}

