package com.sinosoftgz.starter.mail.core.handler.biz;

import com.sinosoftgz.starter.mail.core.enums.MailBodyType;
import com.sinosoftgz.starter.mail.core.enums.MailPlatformType;
import com.sinosoftgz.starter.mail.core.handler.annotation.MailHandlerType;
import com.sinosoftgz.starter.mail.core.properties.MailPlatformProperties;
import com.sinosoftgz.starter.mail.core.request.FileData;
import com.sinosoftgz.starter.mail.core.request.JavaMailClientReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.validation.Valid;
import java.util.List;


/**
 * @author: Roney
 * @date: 2022-05-09 14:44
 * @description: NetEaseMailHandler
 */

@Component
@MailHandlerType(MailPlatformType.NET_EASE)
@Slf4j
public class NetEaseMailHandler extends DefaultMailHandler {


    @Override
    public void testStrategyPattern() {
        log.debug("NetEaseMailHandler");
    }

    @Override
    public boolean send(@Valid JavaMailClientReq javaMailClientReq) {
        checkJavaMailClient(javaMailClientReq);
        /**
         * todo： 增加重复拦截，10秒内，不允许向同一个用户发送相同的邮件，服务未连接redis，暂时不做防重
         */
        log.info("网易邮件客户端平台实现");
        return false;
    }


}
