/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.mail.core.handler.biz;

import cn.hutool.core.codec.Base64;
import com.sinosoftgz.starter.mail.core.enums.MailBodyType;
import com.sinosoftgz.starter.mail.core.enums.MailPlatformType;
import com.sinosoftgz.starter.mail.core.handler.annotation.MailHandlerType;
import com.sinosoftgz.starter.mail.core.handler.biz.DefaultMailHandler;
import com.sinosoftgz.starter.mail.core.properties.MailPlatformProperties;
import com.sinosoftgz.starter.mail.core.request.FileData;
import com.sinosoftgz.starter.mail.core.request.JavaMailClientReq;
import com.sinosoftgz.starter.utils.date.DateUtils;
import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@MailHandlerType(value=MailPlatformType.SPRING_BOOT_MAIL)
public class SpringBootMailHandler
extends DefaultMailHandler {
    private static final Logger log = LoggerFactory.getLogger(SpringBootMailHandler.class);
    @Autowired
    MailProperties mailProperties;
    @Autowired
    MailPlatformProperties mailPlatformProperties;
    @Autowired
    JavaMailSender javaMailSender;

    public void testStrategyPattern() {
        log.debug("SpringBootMailHandler");
    }

    public boolean send(@Valid JavaMailClientReq javaMailClientReq) {
        this.checkJavaMailClient(javaMailClientReq);
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        try {
            helper = new MimeMessageHelper(mimeMessage, true);
        }
        catch (MessagingException e) {
            log.error("\u8bbe\u7f6e\u5e26\u9644\u4ef6\u53c2\u6570\u9519\u8bef", (Throwable)e);
        }
        try {
            String[] recipientTos = javaMailClientReq.getRecipientTos().toArray(new String[0]);
            helper.setFrom(this.mailProperties.getUsername());
            helper.setTo(recipientTos);
            helper.setSubject(javaMailClientReq.getSubject());
            helper.setSentDate(DateUtils.now());
            this.updateText(javaMailClientReq, helper);
            this.updateCc(helper, javaMailClientReq.getRecipientCc());
            this.updateCc(helper, javaMailClientReq.getRecipientBcc());
            this.updateAttachment(javaMailClientReq, helper);
            this.updateImage(javaMailClientReq, helper);
        }
        catch (MessagingException e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)e);
            return false;
        }
        this.javaMailSender.send(mimeMessage);
        return true;
    }

    private void updateText(JavaMailClientReq javaMailClient, MimeMessageHelper helper) throws MessagingException {
        if (MailBodyType.HTML.equals((Object)javaMailClient.getMailBodyType())) {
            helper.setText(javaMailClient.getContent(), true);
        } else {
            helper.setText(javaMailClient.getContent());
        }
    }

    private void updateCc(MimeMessageHelper helper, List<String> recipientCc) throws MessagingException {
        if (!CollectionUtils.isEmpty(recipientCc)) {
            helper.setCc(recipientCc.toArray(new String[0]));
        }
    }

    private void updateAttachment(JavaMailClientReq javaMailClient, MimeMessageHelper helper) {
        if (!CollectionUtils.isEmpty((Collection)javaMailClient.getAttachments())) {
            javaMailClient.getAttachments().stream().forEach(fileData -> {
                ByteArrayResource source = null;
                source = StringUtils.hasLength((String)fileData.getBase64Str()) ? new ByteArrayResource(Base64.decode((CharSequence)fileData.getBase64Str())) : new ByteArrayResource(fileData.getData());
                try {
                    helper.addAttachment(fileData.getFileName(), (InputStreamSource)source);
                }
                catch (MessagingException e) {
                    log.error("\u8bbe\u7f6e\u90ae\u4ef6\u9644\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            });
        }
    }

    private void updateImage(JavaMailClientReq javaMailClient, MimeMessageHelper helper) {
        if (!CollectionUtils.isEmpty((Collection)javaMailClient.getImages())) {
            List images = javaMailClient.getImages();
            for (int i = 0; i < images.size(); ++i) {
                try {
                    FileData fileData = (FileData)images.get(i);
                    ByteArrayResource source = null;
                    source = StringUtils.hasLength((String)fileData.getBase64Str()) ? new ByteArrayResource(Base64.decode((CharSequence)fileData.getBase64Str())) : new ByteArrayResource(fileData.getData());
                    String contentId = this.mailPlatformProperties.getMailImageContentIdPrefix() + i;
                    helper.addInline(contentId, (InputStreamSource)source, "image/jpeg");
                    continue;
                }
                catch (MessagingException e) {
                    log.error("\u8bbe\u7f6e\u90ae\u4ef6\u56fe\u7247\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }
}

