/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notifys;

import com.alibaba.fastjson.JSON;
import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.notify.MailNotifier;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;

public class CustomMailNotifier
extends MailNotifier {
    private static final String DEFAULT_SUBJECT = "#{application.name} (#{application.id}) is #{to.status}";
    private static final String DEFAULT_TEXT = "#{application.name} (#{application.id})\nstatus changed from #{from.status} to #{to.status}\n\n#{application.healthUrl}";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final MailSender sender;
    private String[] to = new String[]{"root@localhost"};
    private String[] cc;
    private String from = null;
    private Expression text;
    private Expression subject;

    public CustomMailNotifier(MailSender sender) {
        super(sender);
        this.sender = sender;
        this.subject = this.parser.parseExpression(DEFAULT_SUBJECT, ParserContext.TEMPLATE_EXPRESSION);
        this.text = this.parser.parseExpression(DEFAULT_TEXT, ParserContext.TEMPLATE_EXPRESSION);
    }

    protected void doNotify(ClientApplicationEvent event) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)event);
        SimpleMailMessage message = new SimpleMailMessage();
        message.setTo(this.to);
        message.setFrom(this.from);
        message.setSubject((String)this.subject.getValue((EvaluationContext)context, String.class));
        message.setText((String)this.text.getValue((EvaluationContext)context, String.class) + " \n\n " + JSON.toJSONString((Object)event.getApplication(), (boolean)true));
        message.setCc(this.cc);
        this.sender.send(message);
    }
}

