//package de.codecentric.boot.admin.notifys;
//
//import com.alibaba.fastjson.JSON;
//
//import de.codecentric.boot.admin.server.notify.MailNotifier;
//import org.springframework.expression.EvaluationContext;
//import org.springframework.expression.Expression;
//import org.springframework.expression.ParserContext;
//import org.springframework.expression.spel.standard.SpelExpressionParser;
//import org.springframework.expression.spel.support.StandardEvaluationContext;
//import org.springframework.mail.MailSender;
//import org.springframework.mail.SimpleMailMessage;
//
//public class CustomMailNotifier extends MailNotifier {
//    private static final String DEFAULT_SUBJECT = "#{application.name} (#{application.id}) is #{to.status}";
//    private static final String DEFAULT_TEXT = "#{application.name} (#{application.id})\nstatus changed from #{from.status} to #{to.status}\n\n#{application.healthUrl}";
//
//    private final SpelExpressionParser parser = new SpelExpressionParser();
//    private final MailSender sender;
//
//    /**
//     * recipients of the mail
//     */
//    private String to[] = {"root@localhost"};
//
//    /**
//     * cc-recipients of the mail
//     */
//    private String cc[];
//
//    /**
//     * sender of the change
//     */
//    private String from = null;
//
//    /**
//     * Mail Text. SpEL template using event as root;
//     */
//    private Expression text;
//
//    /**
//     * Mail Subject. SpEL template using event as root;
//     */
//    private Expression subject;
//
//    public CustomMailNotifier(MailSender sender) {
//        super(sender);
//        this.sender = sender;
//        this.subject = parser.parseExpression(DEFAULT_SUBJECT, ParserContext.TEMPLATE_EXPRESSION);
//        this.text = parser.parseExpression(DEFAULT_TEXT, ParserContext.TEMPLATE_EXPRESSION);
//    }
//
//    @Override
//    protected void doNotify(ClientApplicationEvent event) {
//        EvaluationContext context = new StandardEvaluationContext(event);
//
//        SimpleMailMessage message = new SimpleMailMessage();
//        message.setTo(to);
//        message.setFrom(from);
//        message.setSubject(subject.getValue(context, String.class));
//        message.setText(text.getValue(context, String.class) + " \n\n " + JSON.toJSONString(event.getApplication(), true));
//        message.setCc(cc);
//        sender.send(message);
//    }
//
//
//}
