/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.activemq.config;

import com.sinosoftgz.starter.activemq.utils.ActiveMqUtils;
import javax.jms.ConnectionFactory;
import org.springframework.boot.autoconfigure.jms.DefaultJmsListenerContainerFactoryConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessageType;

@Configuration
@EnableJms
public class ActiveMqConfiguration {
    public static final String QUEUE_LISTENER_FACTORY = "queueListenerFactory";
    public static final String TOPIC_LISTENER_FACTORY = "topicListenerFactory";

    @Bean
    public JmsListenerContainerFactory<?> queueListenerFactory(ConnectionFactory connectionFactory, DefaultJmsListenerContainerFactoryConfigurer configurer) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        configurer.configure(factory, connectionFactory);
        return factory;
    }

    @Bean
    public JmsListenerContainerFactory<?> topicListenerFactory(ConnectionFactory connectionFactory, DefaultJmsListenerContainerFactoryConfigurer configurer) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        configurer.configure(factory, connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(true));
        return factory;
    }

    @Bean(name={"topicJmsTemplate"})
    public JmsTemplate topicJmsTemplate(ConnectionFactory connectionFactory) {
        JmsTemplate topicJmsTemplate = new JmsTemplate(connectionFactory);
        topicJmsTemplate.setDeliveryPersistent(true);
        topicJmsTemplate.setPubSubDomain(true);
        MessageConverter messageConverter = this.jacksonJmsMessageConverter();
        topicJmsTemplate.setMessageConverter(messageConverter);
        return topicJmsTemplate;
    }

    @Primary
    @Bean(name={"queueJmsTemplate"})
    public JmsTemplate queueJmsTemplate(ConnectionFactory connectionFactory) {
        JmsTemplate jmsTemplate = new JmsTemplate(connectionFactory);
        MessageConverter messageConverter = this.jacksonJmsMessageConverter();
        jmsTemplate.setMessageConverter(messageConverter);
        return jmsTemplate;
    }

    @Bean(value={"jacksonJmsMessageConverter"})
    public MessageConverter jacksonJmsMessageConverter() {
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setTargetType(MessageType.TEXT);
        converter.setTypeIdPropertyName("_type");
        return converter;
    }

    @Bean
    ActiveMqUtils activeMqUtil(ConnectionFactory connectionFactory) {
        return new ActiveMqUtils(this.queueJmsTemplate(connectionFactory), this.topicJmsTemplate(connectionFactory));
    }
}

