/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.activemq.config;

import com.sinosoftgz.starter.activemq.config.ActiveMqConfiguration;
import com.sinosoftgz.starter.activemq.utils.ActiveMqUtils;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;

@Configuration
@ConfigurationProperties(prefix="activemq.retry")
@ConditionalOnProperty(name={"activemq.retry.enabled"}, havingValue="true")
@Import(value={ActiveMqConfiguration.class})
public class RedeliveryPolicyConfiguration
implements InitializingBean {
    @Autowired
    PooledConnectionFactory pooledConnectionFactory;
    private boolean useExponentialBackOff = true;
    private int maximumRedeliveries = 6;
    private long maximumRedeliveryDelay = -1L;
    private long initialRedeliveryDelay = 1000L;
    private double backOffMultiplier = 5.0;
    @Resource(name="queueJmsTemplate")
    JmsTemplate queueJmsTemplate;
    @Resource(name="topicJmsTemplate")
    JmsTemplate topicJmsTemplate;
    @Resource(name="jacksonJmsMessageConverter")
    MessageConverter jacksonJmsMessageConverter;

    @Bean
    public RedeliveryPolicy redeliveryPolicy() {
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setUseExponentialBackOff(this.useExponentialBackOff);
        redeliveryPolicy.setMaximumRedeliveries(this.maximumRedeliveries);
        redeliveryPolicy.setInitialRedeliveryDelay(this.initialRedeliveryDelay);
        redeliveryPolicy.setBackOffMultiplier(this.backOffMultiplier);
        redeliveryPolicy.setMaximumRedeliveryDelay(this.maximumRedeliveryDelay);
        return redeliveryPolicy;
    }

    public void afterPropertiesSet() throws Exception {
        ((ActiveMQConnectionFactory)this.pooledConnectionFactory.getConnectionFactory()).setRedeliveryPolicy(this.redeliveryPolicy());
    }

    @Bean(name={"redeliveryPolicyJmsTemplate"})
    JmsTemplate redeliveryPolicyJmsTemplate() {
        ActiveMQConnectionFactory activeMQConnectionFactory = ((ActiveMQConnectionFactory)this.pooledConnectionFactory.getConnectionFactory()).copy();
        activeMQConnectionFactory.setRedeliveryPolicy(this.redeliveryPolicy());
        JmsTemplate jmsTemplate = new JmsTemplate((ConnectionFactory)activeMQConnectionFactory);
        MessageConverter messageConverter = this.jacksonJmsMessageConverter;
        jmsTemplate.setMessageConverter(messageConverter);
        return jmsTemplate;
    }

    @Bean
    ActiveMqUtils activeMqUtil(JmsTemplate redeliveryPolicyJmsTemplate) {
        return new ActiveMqUtils(this.topicJmsTemplate, this.queueJmsTemplate, redeliveryPolicyJmsTemplate);
    }

    public PooledConnectionFactory getPooledConnectionFactory() {
        return this.pooledConnectionFactory;
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public long getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public long getInitialRedeliveryDelay() {
        return this.initialRedeliveryDelay;
    }

    public double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public JmsTemplate getQueueJmsTemplate() {
        return this.queueJmsTemplate;
    }

    public JmsTemplate getTopicJmsTemplate() {
        return this.topicJmsTemplate;
    }

    public MessageConverter getJacksonJmsMessageConverter() {
        return this.jacksonJmsMessageConverter;
    }

    public void setPooledConnectionFactory(PooledConnectionFactory pooledConnectionFactory) {
        this.pooledConnectionFactory = pooledConnectionFactory;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public void setMaximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public void setInitialRedeliveryDelay(long initialRedeliveryDelay) {
        this.initialRedeliveryDelay = initialRedeliveryDelay;
    }

    public void setBackOffMultiplier(double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public void setQueueJmsTemplate(JmsTemplate queueJmsTemplate) {
        this.queueJmsTemplate = queueJmsTemplate;
    }

    public void setTopicJmsTemplate(JmsTemplate topicJmsTemplate) {
        this.topicJmsTemplate = topicJmsTemplate;
    }

    public void setJacksonJmsMessageConverter(MessageConverter jacksonJmsMessageConverter) {
        this.jacksonJmsMessageConverter = jacksonJmsMessageConverter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedeliveryPolicyConfiguration)) {
            return false;
        }
        RedeliveryPolicyConfiguration other = (RedeliveryPolicyConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PooledConnectionFactory this$pooledConnectionFactory = this.getPooledConnectionFactory();
        PooledConnectionFactory other$pooledConnectionFactory = other.getPooledConnectionFactory();
        if (this$pooledConnectionFactory == null ? other$pooledConnectionFactory != null : !this$pooledConnectionFactory.equals(other$pooledConnectionFactory)) {
            return false;
        }
        if (this.isUseExponentialBackOff() != other.isUseExponentialBackOff()) {
            return false;
        }
        if (this.getMaximumRedeliveries() != other.getMaximumRedeliveries()) {
            return false;
        }
        if (this.getMaximumRedeliveryDelay() != other.getMaximumRedeliveryDelay()) {
            return false;
        }
        if (this.getInitialRedeliveryDelay() != other.getInitialRedeliveryDelay()) {
            return false;
        }
        if (Double.compare(this.getBackOffMultiplier(), other.getBackOffMultiplier()) != 0) {
            return false;
        }
        JmsTemplate this$queueJmsTemplate = this.getQueueJmsTemplate();
        JmsTemplate other$queueJmsTemplate = other.getQueueJmsTemplate();
        if (this$queueJmsTemplate == null ? other$queueJmsTemplate != null : !this$queueJmsTemplate.equals(other$queueJmsTemplate)) {
            return false;
        }
        JmsTemplate this$topicJmsTemplate = this.getTopicJmsTemplate();
        JmsTemplate other$topicJmsTemplate = other.getTopicJmsTemplate();
        if (this$topicJmsTemplate == null ? other$topicJmsTemplate != null : !this$topicJmsTemplate.equals(other$topicJmsTemplate)) {
            return false;
        }
        MessageConverter this$jacksonJmsMessageConverter = this.getJacksonJmsMessageConverter();
        MessageConverter other$jacksonJmsMessageConverter = other.getJacksonJmsMessageConverter();
        return !(this$jacksonJmsMessageConverter == null ? other$jacksonJmsMessageConverter != null : !this$jacksonJmsMessageConverter.equals(other$jacksonJmsMessageConverter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedeliveryPolicyConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PooledConnectionFactory $pooledConnectionFactory = this.getPooledConnectionFactory();
        result = result * 59 + ($pooledConnectionFactory == null ? 43 : $pooledConnectionFactory.hashCode());
        result = result * 59 + (this.isUseExponentialBackOff() ? 79 : 97);
        result = result * 59 + this.getMaximumRedeliveries();
        long $maximumRedeliveryDelay = this.getMaximumRedeliveryDelay();
        result = result * 59 + (int)($maximumRedeliveryDelay >>> 32 ^ $maximumRedeliveryDelay);
        long $initialRedeliveryDelay = this.getInitialRedeliveryDelay();
        result = result * 59 + (int)($initialRedeliveryDelay >>> 32 ^ $initialRedeliveryDelay);
        long $backOffMultiplier = Double.doubleToLongBits(this.getBackOffMultiplier());
        result = result * 59 + (int)($backOffMultiplier >>> 32 ^ $backOffMultiplier);
        JmsTemplate $queueJmsTemplate = this.getQueueJmsTemplate();
        result = result * 59 + ($queueJmsTemplate == null ? 43 : $queueJmsTemplate.hashCode());
        JmsTemplate $topicJmsTemplate = this.getTopicJmsTemplate();
        result = result * 59 + ($topicJmsTemplate == null ? 43 : $topicJmsTemplate.hashCode());
        MessageConverter $jacksonJmsMessageConverter = this.getJacksonJmsMessageConverter();
        result = result * 59 + ($jacksonJmsMessageConverter == null ? 43 : $jacksonJmsMessageConverter.hashCode());
        return result;
    }

    public String toString() {
        return "RedeliveryPolicyConfiguration(pooledConnectionFactory=" + this.getPooledConnectionFactory() + ", useExponentialBackOff=" + this.isUseExponentialBackOff() + ", maximumRedeliveries=" + this.getMaximumRedeliveries() + ", maximumRedeliveryDelay=" + this.getMaximumRedeliveryDelay() + ", initialRedeliveryDelay=" + this.getInitialRedeliveryDelay() + ", backOffMultiplier=" + this.getBackOffMultiplier() + ", queueJmsTemplate=" + this.getQueueJmsTemplate() + ", topicJmsTemplate=" + this.getTopicJmsTemplate() + ", jacksonJmsMessageConverter=" + this.getJacksonJmsMessageConverter() + ")";
    }
}

