package com.sinosoftgz.starter.activemq.utils;

import jdk.nashorn.internal.ir.debug.ObjectSizeCalculator;
import lombok.extern.slf4j.Slf4j;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;

import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

/**
 * Created by Roney on 2019/8/19.
 *
 * @author Roney
 * @date 2019-08-19 15:30
 */
@Slf4j
public class ActiveMqUtils {

    /**
     * 大小限制 20M
     */
    private static final long MAX_SIZE = 20 * 1048576;

    JmsTemplate topicJmsTemplate;
    JmsTemplate queueJmsTemplate;


    public ActiveMqUtils(JmsTemplate queueJmsTemplate, JmsTemplate topicJmsTemplate) {
        this.queueJmsTemplate = queueJmsTemplate;
        this.topicJmsTemplate = topicJmsTemplate;
    }


    /**
     * 发送topic
     *
     * @param topicName
     * @param message
     */
    public void sendTopic(String topicName, Object message) {
        log.debug("sendTopic topicName:{},message:{}", topicName, message);
        checkObjectSize(topicName, message);
        if (message instanceof MessageCreator) {
            topicJmsTemplate.send((new ActiveMQTopic(topicName)), (MessageCreator) message);
        } else {
            topicJmsTemplate.convertAndSend(topicName, message);
        }
    }

    /**
     * 发送队列
     *
     * @param queueName
     * @param message
     */
    public void sendQueue(String queueName, Object message) {
        log.debug("sendQueue queueName:{},message:{}", queueName, message);
        checkObjectSize(queueName, message);
        if (message instanceof MessageCreator) {
            queueJmsTemplate.send((new ActiveMQQueue(queueName)), (MessageCreator) message);
        } else {
            queueJmsTemplate.convertAndSend(queueName, message);
        }
    }


    /**
     * 发送延迟队列
     *
     * @param queueName
     * @param message
     */
    public void sendDelayQueue(String queueName, MessageCreator message) {
        log.debug("sendDelayQueue queueName:{},message:{}", queueName, message);
        checkObjectSize(queueName, message);
        queueJmsTemplate.send((new ActiveMQQueue(queueName)), message);
    }


    /**
     * 检查对象大小
     *
     * @param queueName
     * @param message
     */
    private void checkObjectSize(String queueName, Object message) {
        /**
         * ObjectSizeCalculator.getObjectSize  返回字节大小
         */
//        long sizeOf= ObjectSizeCalculator.getObjectSize(message);
//        log.info("消息队列：{}，存放的消息大小为：{}",queueName,sizeOf/1048576);
//        if(MAX_SIZE<sizeOf){
//            log.error("请不要存放大于20M的消息。消息大小：{} M",sizeOf/1048576);
//            throw new RuntimeException("请不要存放大于20M的消息。");
//        }
    }
}
