/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.activemq.utils;

import javax.jms.Destination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class ActiveMqUtils {
    private static final Logger log = LoggerFactory.getLogger(ActiveMqUtils.class);
    private static final long MAX_SIZE = 0x1400000L;
    JmsTemplate topicJmsTemplate;
    JmsTemplate queueJmsTemplate;

    public ActiveMqUtils(JmsTemplate queueJmsTemplate, JmsTemplate topicJmsTemplate) {
        this.queueJmsTemplate = queueJmsTemplate;
        this.topicJmsTemplate = topicJmsTemplate;
    }

    public void sendTopic(String topicName, Object message) {
        log.debug("sendTopic topicName:{},message:{}", (Object)topicName, message);
        this.checkObjectSize(topicName, message);
        if (message instanceof MessageCreator) {
            this.topicJmsTemplate.send((Destination)new ActiveMQTopic(topicName), (MessageCreator)message);
        } else {
            this.topicJmsTemplate.convertAndSend(topicName, message);
        }
    }

    public void sendQueue(String queueName, Object message) {
        log.debug("sendQueue queueName:{},message:{}", (Object)queueName, message);
        this.checkObjectSize(queueName, message);
        if (message instanceof MessageCreator) {
            this.queueJmsTemplate.send((Destination)new ActiveMQQueue(queueName), (MessageCreator)message);
        } else {
            this.queueJmsTemplate.convertAndSend(queueName, message);
        }
    }

    public void sendDelayQueue(String queueName, MessageCreator message) {
        log.debug("sendDelayQueue queueName:{},message:{}", (Object)queueName, (Object)message);
        this.checkObjectSize(queueName, message);
        this.queueJmsTemplate.send((Destination)new ActiveMQQueue(queueName), message);
    }

    private void checkObjectSize(String queueName, Object message) {
    }
}

