/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.kafka.config;

import com.sinosoftgz.starter.kafka.utils.KafkaUtils;
import java.beans.ConstructorProperties;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
@EnableConfigurationProperties(value={KafkaProperties.class})
@EnableKafka
public class KafkaConfiguration {
    private final KafkaProperties kafkaProperties;

    @Bean
    public KafkaTemplate<String, String> kafkaTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }

    @Bean
    public ProducerFactory<String, String> producerFactory() {
        return new DefaultKafkaProducerFactory(this.kafkaProperties.buildProducerProperties());
    }

    @Bean
    public ConcurrentKafkaListenerContainerFactory<String, String> kafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(this.kafkaProperties.getListener().getConcurrency());
        factory.setBatchListener(Boolean.valueOf(true));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean
    public ConsumerFactory<String, String> consumerFactory() {
        return new DefaultKafkaConsumerFactory(this.kafkaProperties.buildConsumerProperties());
    }

    @Bean(value={"ackContainerFactory"})
    public ConcurrentKafkaListenerContainerFactory<String, String> ackContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.getContainerProperties().setAckMode(this.kafkaProperties.getListener().getAckMode());
        factory.setConcurrency(this.kafkaProperties.getListener().getConcurrency());
        return factory;
    }

    @Bean
    KafkaUtils kafkaUtils(KafkaTemplate<String, String> kafkaTemplate) {
        return new KafkaUtils(kafkaTemplate);
    }

    @ConstructorProperties(value={"kafkaProperties"})
    public KafkaConfiguration(KafkaProperties kafkaProperties) {
        this.kafkaProperties = kafkaProperties;
    }
}

