package com.sinosoftgz.starter.kafka.utils;

import lombok.extern.slf4j.Slf4j;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

/**
 * Created by Roney on 2019/11/20.
 *
 * @author Roney
 * @date 2019-11-20 15:54
 */
@Slf4j
public class KafkaUtils {

    KafkaTemplate<String, String> kafkaTemplate;

    public KafkaUtils(KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    /**
     * 发送topic
     *
     * @param topicName
     * @param message
     */
    public void sendTopic(String topicName, String message) {
        log.debug("sendTopic topicName:{},message:{}", topicName, message);
        try {
            ListenableFuture<SendResult<String, String>> future = kafkaTemplate.send(topicName, message);
        } catch (Exception e) {
            e.printStackTrace();
        }
//        future.addCallback(new ListenableFutureCallback<SendResult<String, String>>() {
//
//            @Override
//            public void onSuccess(SendResult<String, String> result) {
//                log.info("send success {}", result.getProducerRecord().value());
//
//            }
//
//            @Override
//            public void onFailure(Throwable ex) {
//                log.warn("send fail {}", ex.getMessage());
//
//            }
//
//        });
    }
}
