/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.rabbitmq.config;

import com.sinosoftgz.global.common.utils.LangUtils;
import com.sinosoftgz.starter.rabbitmq.utils.RabbitMqUtils;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableRabbit
public class RabbitMqConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqConfiguration.class);
    @Autowired
    RabbitProperties rabbitProperties;

    @Bean
    public RabbitAdmin rabbitAdmin(ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean
    public RabbitTemplate rabbitTemplate(CachingConnectionFactory connectionFactory) {
        connectionFactory.setPublisherConfirms(true);
        connectionFactory.setPublisherReturns(true);
        RabbitTemplate rabbitTemplate = new RabbitTemplate((ConnectionFactory)connectionFactory);
        rabbitTemplate.setMandatory(true);
        rabbitTemplate.setMessageConverter((MessageConverter)this.jackson2Converter());
        rabbitTemplate.setConfirmCallback((correlationData, ack, cause) -> log.info("\u6d88\u606f\u53d1\u9001\u6210\u529f:correlationData({}),ack({}),cause({})", new Object[]{correlationData, ack, cause}));
        rabbitTemplate.setReturnCallback((message, replyCode, replyText, exchange, routingKey) -> log.info("\u6d88\u606f\u4e22\u5931:exchange({}),route({}),replyCode({}),replyText({}),message:{}", new Object[]{exchange, routingKey, replyCode, replyText, message}));
        return rabbitTemplate;
    }

    @Bean
    public RabbitListenerContainerFactory<?> rabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        AcknowledgeMode acknowledgeMode = this.rabbitProperties.getListener().getSimple().getAcknowledgeMode();
        if (!LangUtils.isEmpty((Object)acknowledgeMode)) {
            factory.setAcknowledgeMode(acknowledgeMode);
            log.info("\u6d88\u606f\u786e\u8ba4\u65b9\u5f0f\u4e3a\uff1a{}", (Object)acknowledgeMode);
        } else {
            factory.setAcknowledgeMode(AcknowledgeMode.AUTO);
            log.info("\u6d88\u606f\u786e\u8ba4\u65b9\u5f0f\u4e3a\uff1a{}", (Object)AcknowledgeMode.AUTO);
        }
        factory.setConnectionFactory(connectionFactory);
        factory.setMessageConverter((MessageConverter)this.jackson2Converter());
        return factory;
    }

    @Bean
    public Jackson2JsonMessageConverter jackson2Converter() {
        Jackson2JsonMessageConverter converter = new Jackson2JsonMessageConverter();
        return converter;
    }

    @Bean
    public Queue directOneQueue() {
        return new Queue("queue.direct.1");
    }

    @Bean
    public Queue queueTwo() {
        return new Queue("queue.2");
    }

    @Bean
    public Queue queueThree() {
        return new Queue("3.queue");
    }

    @Bean
    public FanoutExchange fanoutExchange() {
        return new FanoutExchange("fanout.mode");
    }

    @Bean
    public Binding fanoutBinding1(Queue directOneQueue, FanoutExchange fanoutExchange) {
        return BindingBuilder.bind((Queue)directOneQueue).to(fanoutExchange);
    }

    @Bean
    public Binding fanoutBinding2(Queue queueTwo, FanoutExchange fanoutExchange) {
        return BindingBuilder.bind((Queue)queueTwo).to(fanoutExchange);
    }

    @Bean
    public TopicExchange topicExchange() {
        return new TopicExchange("topic.mode");
    }

    @Bean
    public Binding topicBinding1(FanoutExchange fanoutExchange, TopicExchange topicExchange) {
        return BindingBuilder.bind((Exchange)fanoutExchange).to(topicExchange).with("queue.#");
    }

    @Bean
    public Binding topicBinding2(Queue queueTwo, TopicExchange topicExchange) {
        return BindingBuilder.bind((Queue)queueTwo).to(topicExchange).with("*.queue");
    }

    @Bean
    public Binding topicBinding3(Queue queueThree, TopicExchange topicExchange) {
        return BindingBuilder.bind((Queue)queueThree).to(topicExchange).with("3.queue");
    }

    @Bean
    public Queue delayQueue() {
        return new Queue("delay.queue", true);
    }

    @Bean
    public CustomExchange delayExchange() {
        ConcurrentHashMap<String, String> args = new ConcurrentHashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange("delay.mode", "x-delayed-message", true, false, args);
    }

    @Bean
    public Binding delayBinding(Queue delayQueue, CustomExchange delayExchange) {
        return BindingBuilder.bind((Queue)delayQueue).to((Exchange)delayExchange).with("delay.queue").noargs();
    }

    @Bean
    RabbitMqUtils rabbitMqUtils(ConnectionFactory connectionFactory, CachingConnectionFactory cachingConnectionFactory) {
        return new RabbitMqUtils(this.rabbitAdmin(connectionFactory), this.rabbitTemplate(cachingConnectionFactory));
    }
}

