package com.sinosoftgz.starter.rabbitmq.constant;

/**
 * Created by Roney on 2019/11/6.
 * 延迟队列
 *
 * @author Roney
 * @date 2019-11-06 16:21
 */
public enum MessageDelayLevel {

    /**
     * "1s 5s 10s 30s 1m 2m 3m 4m 5m 6m 7m 8m 9m 10m 20m 30m 1h 2h"
     */
    /**
     * 1秒
     */
    ONE_S(1 * 1000),

    /**
     * 5秒
     */
    FIVE_S(5 * 1000),
    /**
     * 10秒
     */
    TEN_S(10 * 1000),
    /**
     * 30秒
     */
    TWENTY_S(30 * 1000),
    /**
     * 1分钟
     */
    ONE_M(60 * 1000),
    /**
     * 2分钟
     */
    TWO_M(120 * 1000),
    /**
     * 3分钟
     */
    THREE_M(180 * 1000),
    /**
     * 4分钟
     */
    FOUR_M(240 * 1000),
    /**
     * 5分钟
     */
    FIVE_M(300 * 1000),
    /**
     * 6分钟
     */
    SIX_M(360 * 1000),
    /**
     * 7分钟
     */
    SEVEN_M(420 * 1000),
    /**
     * 8分钟
     */
    EIGHT_M(480 * 1000),
    /**
     * 9分钟
     */
    NINE_M(540 * 1000),
    /**
     * 10分钟
     */
    TEN_M(600 * 1000),
    /**
     * 20分钟
     */
    TWENTY_M(1200 * 1000),
    /**
     * 30分钟
     */
    THIRTY_M(1800 * 1000),
    /**
     * 1小时
     */
    ONE_H(3600 * 1000),
    /**
     * 2小时
     */
    TWO_H(7200 * 1000);

    MessageDelayLevel(int value) {
        this.value = value;
    }

    private int value;

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}
