/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.rabbitmq.utils;

import com.rabbitmq.client.Channel;
import com.sinosoftgz.starter.rabbitmq.constant.MessageDelayLevel;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.util.ObjectUtils;

public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);
    private final RabbitAdmin rabbitAdmin;
    private final RabbitTemplate rabbitTemplate;
    @Autowired
    RabbitProperties rabbitProperties;

    public RabbitMqUtils(RabbitAdmin rabbitAdmin, RabbitTemplate rabbitTemplate) {
        this.rabbitAdmin = rabbitAdmin;
        this.rabbitTemplate = rabbitTemplate;
    }

    public void addExchange(AbstractExchange exchange) {
        this.rabbitAdmin.declareExchange((Exchange)exchange);
    }

    public boolean deleteExchange(String exchangeName) {
        return this.rabbitAdmin.deleteExchange(exchangeName);
    }

    public Queue addQueue() {
        return this.rabbitAdmin.declareQueue();
    }

    public String addQueue(Queue queue) {
        return this.rabbitAdmin.declareQueue(queue);
    }

    public void deleteQueue(String queueName, boolean unused, boolean empty) {
        this.rabbitAdmin.deleteQueue(queueName, unused, empty);
    }

    public boolean deleteQueue(String queueName) {
        return this.rabbitAdmin.deleteQueue(queueName);
    }

    public void addBinding(Queue queue, TopicExchange exchange, String routingKey) {
        Binding binding = BindingBuilder.bind((Queue)queue).to(exchange).with(routingKey);
        this.rabbitAdmin.declareBinding(binding);
    }

    public void addBinding(Exchange exchange, TopicExchange topicExchange, String routingKey) {
        Binding binding = BindingBuilder.bind((Exchange)exchange).to(topicExchange).with(routingKey);
        this.rabbitAdmin.declareBinding(binding);
    }

    public void removeBinding(Binding binding) {
        this.rabbitAdmin.removeBinding(binding);
    }

    public void basicAck(Message message, Channel channel) {
        this.checkAcknowledgeMode();
        long deliveryTag = message.getMessageProperties().getDeliveryTag();
        try {
            channel.basicAck(deliveryTag, false);
        }
        catch (IOException e) {
            log.error("\u901a\u77e5 MQ \u6d88\u606f\u5df2\u88ab\u6210\u529f\u6d88\u8d39,\u53ef\u4ee5ACK\u4e86\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
    }

    private void basicRecover(Channel channel) {
        try {
            channel.basicRecover();
        }
        catch (IOException e) {
            log.error("\u5904\u7406\u5931\u8d25,\u91cd\u65b0\u538b\u5165MQ\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
    }

    public void basicAckAndRecover(Message message, Channel channel) {
        this.checkAcknowledgeMode();
        long deliveryTag = message.getMessageProperties().getDeliveryTag();
        try {
            channel.basicAck(deliveryTag, false);
        }
        catch (IOException e) {
            log.error("\u901a\u77e5 MQ \u6d88\u606f\u5df2\u88ab\u6210\u529f\u6d88\u8d39,\u53ef\u4ee5ACK\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            this.basicRecover(channel);
        }
    }

    private void checkAcknowledgeMode() {
        AcknowledgeMode acknowledgeMode = this.rabbitProperties.getListener().getSimple().getAcknowledgeMode();
        if (!ObjectUtils.isEmpty((Object)acknowledgeMode)) {
            if (AcknowledgeMode.MANUAL != acknowledgeMode) {
                log.error("\u914d\u7f6e\u7684\u6d88\u606f\u786e\u8ba4\u6a21\u5f0f\u4e0d\u662f\u624b\u52a8\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u624b\u52a8\u786e\u8ba4\uff0c\u914d\u7f6e\u7684\u6d88\u606f\u786e\u8ba4\u6a21\u5f0f\u4e3a\uff1a{} ", (Object)acknowledgeMode);
                throw new RuntimeException("\u914d\u7f6e\u7684\u6d88\u606f\u786e\u8ba4\u6a21\u5f0f\u4e0d\u662f\u624b\u52a8\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u624b\u52a8\u786e\u8ba4\u3002");
            }
            if (AcknowledgeMode.AUTO == acknowledgeMode) {
                log.info("\u914d\u7f6e\u7684\u6d88\u606f\u786e\u8ba4\u4e3a\uff1a{} \u3002\u8bf7\u786e\u4fdd\u6d88\u8d39\u65b9\u6ca1\u6709\u624b\u52a8\u786e\u8ba4\u6d88\u606f\uff0c\u5426\u5219\u5c06\u629b\u51fa\u5982\u4e0b\u5f02\u5e38\uff1aCaused by: org.springframework.amqp.AmqpException: PublisherCallbackChannel is closed", (Object)AcknowledgeMode.AUTO);
            }
        } else {
            log.info("\u672a\u914d\u7f6e\u7684\u6d88\u606f\u786e\u8ba4\u6a21\u5f0f\uff0c\u9ed8\u8ba4\u4e3a\uff1a{} \u3002\u8bf7\u786e\u4fdd\u6d88\u8d39\u65b9\u6ca1\u6709\u624b\u52a8\u786e\u8ba4\u6d88\u606f\uff0c\u5426\u5219\u5c06\u629b\u51fa\u5982\u4e0b\u5f02\u5e38\uff1aCaused by: org.springframework.amqp.AmqpException: PublisherCallbackChannel is closed", (Object)AcknowledgeMode.AUTO);
        }
    }

    public void directQueue(String queueName, Object message) {
        log.debug("directQueue queueName:{},message:{}", (Object)queueName, message);
        this.rabbitTemplate.convertAndSend(queueName, message);
    }

    public void fanoutExchange(String queueName, String routingKey, Object message) {
        log.debug("fanoutExchange queueName:{},routingKey:{},message:{}", new Object[]{queueName, routingKey, message});
        this.rabbitTemplate.convertAndSend(queueName, routingKey, message);
    }

    public void topicExchange(String queueName, String routingKey, Object message) {
        log.debug("topicExchange queueName:{},routingKey:{},message:{}", new Object[]{queueName, routingKey, message});
        this.rabbitTemplate.convertAndSend(queueName, routingKey, message);
    }

    public void delayQueue(String exchange, String queueName, Object message, MessageDelayLevel messageDelayLevel) {
        log.debug("delayQueue exchange:{},queueName:{},message:{}", new Object[]{exchange, queueName, message});
        this.rabbitTemplate.convertAndSend(exchange, queueName, message, messagePostProcessor -> {
            messagePostProcessor.getMessageProperties().setHeader("x-delay", (Object)messageDelayLevel.getValue());
            return messagePostProcessor;
        });
    }
}

