/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.rocketmq.utils;

import com.sinosoftgz.starter.rocketmq.constant.MessageDelayLevel;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class RocketMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RocketMqUtils.class);
    RocketMQTemplate rocketMQTemplate;

    public RocketMqUtils(RocketMQTemplate rocketMQTemplate) {
        this.rocketMQTemplate = rocketMQTemplate;
    }

    public void sendTopic(String topicName, Object message) {
        Assert.notNull((Object)topicName, (String)"topicName is null ");
        Assert.notNull((Object)message, (String)"message is null ");
        log.debug("sendTopic topicName:{},message:{}", (Object)topicName, message);
        this.rocketMQTemplate.convertAndSend((Object)topicName, message);
    }

    public SendResult syncSendQueue(String queueName, Object message) {
        Assert.notNull((Object)queueName, (String)"queueName is null ");
        Assert.notNull((Object)message, (String)"message is null ");
        log.debug("syncSendQueue queueName:{},message:{}", (Object)queueName, message);
        SendResult result = this.rocketMQTemplate.syncSend(queueName, message);
        log.debug("syncSendQueue result:{}", (Object)result);
        return result;
    }

    public void asyncSendQueue(String queueName, Object message) {
        Assert.notNull((Object)queueName, (String)"queueName is null ");
        Assert.notNull((Object)message, (String)"message is null ");
        log.debug("asyncSendQueue queueName:{},message:{}", (Object)queueName, message);
        this.rocketMQTemplate.asyncSend(queueName, message, new SendCallback(){

            public void onSuccess(SendResult var1) {
                log.debug("async onSuccess SendResult={}", (Object)var1);
            }

            public void onException(Throwable var1) {
                log.debug("async onException Throwable={}", var1);
            }
        });
    }

    public void asyncSendQueue(String queueName, Object message, SendCallback sendCallback) {
        Assert.notNull((Object)queueName, (String)"queueName is null ");
        Assert.notNull((Object)message, (String)"message is null ");
        log.debug("asyncSendQueue queueName:{},message:{},sendCallback:{}", new Object[]{queueName, message, sendCallback});
        this.rocketMQTemplate.asyncSend(queueName, message, sendCallback);
    }

    public void sendOneWay(String queueName, Object message) {
        Assert.notNull((Object)queueName, (String)"queueName is null ");
        Assert.notNull((Object)message, (String)"message is null ");
        log.debug("sendOneway queueName:{},message:{}", (Object)queueName, message);
        this.rocketMQTemplate.sendOneWay(queueName, message);
    }

    public void asyncDelayQueue(String queueName, Message<?> message, MessageDelayLevel messageDelayLevel) {
        Assert.notNull((Object)queueName, (String)"queueName is null ");
        Assert.notNull(message, (String)"message is null ");
        Assert.notNull((Object)((Object)messageDelayLevel), (String)"messageDelayLevel is null ");
        log.debug("asyncDelayQueue queueName:{},message:{},delayLevel:{}", new Object[]{queueName, message, messageDelayLevel});
        this.rocketMQTemplate.asyncSend(queueName, message, new SendCallback(){

            public void onSuccess(SendResult var1) {
                log.debug("asyncDelayQueue onSuccess SendResult={}", (Object)var1);
            }

            public void onException(Throwable var1) {
                log.debug("asyncDelayQueue onException Throwable={}", var1);
            }
        }, (long)this.rocketMQTemplate.getProducer().getSendMsgTimeout(), messageDelayLevel.getValue());
    }

    public void asyncDelayQueue(String queueName, Message<?> message, MessageDelayLevel messageDelayLevel, SendCallback sendCallback) {
        Assert.notNull((Object)queueName, (String)"queueName is null ");
        Assert.notNull(message, (String)"message is null ");
        Assert.notNull((Object)((Object)messageDelayLevel), (String)"messageDelayLevel is null ");
        log.debug("asyncDelayQueue queueName:{},message:{},delayLevel:{},sendCallback:{}", new Object[]{queueName, message, messageDelayLevel, sendCallback});
        this.rocketMQTemplate.asyncSend(queueName, message, sendCallback, (long)this.rocketMQTemplate.getProducer().getSendMsgTimeout(), messageDelayLevel.getValue());
    }

    public SendResult syncDelayQueue(String queueName, Message<?> message, MessageDelayLevel messageDelayLevel) {
        Assert.notNull((Object)queueName, (String)"queueName is null ");
        Assert.notNull(message, (String)"message is null ");
        Assert.notNull((Object)((Object)messageDelayLevel), (String)"messageDelayLevel is null ");
        log.debug("syncDelayQueue queueName:{},message:{},delayLevel:{}", new Object[]{queueName, message, messageDelayLevel});
        SendResult result = this.rocketMQTemplate.syncSend(queueName, message, (long)this.rocketMQTemplate.getProducer().getSendMsgTimeout(), messageDelayLevel.getValue());
        log.debug("syncDelayQueue result:{}", (Object)result);
        return result;
    }
}

