package com.sinosoftgz.starter.rocketmq.constant;

/**
 * Created by Roney on 2019/11/6.
 * 延迟队列
 *
 * @author Roney
 * @date 2019-11-06 16:21
 */
public enum MessageDelayLevel {

    /**
     * "1s 5s 10s 30s 1m 2m 3m 4m 5m 6m 7m 8m 9m 10m 20m 30m 1h 2h"
     */
    /**
     * 1秒
     */
    ONE_S(1),

    /**
     * 5秒
     */
    FIVE_S(2),
    /**
     * 10秒
     */
    TEN_S(3),
    /**
     * 30秒
     */
    TWENTY_S(4),
    /**
     * 1分钟
     */
    ONE_M(5),
    /**
     * 2分钟
     */
    TWO_M(6),
    /**
     * 3分钟
     */
    THREE_M(7),
    /**
     * 4分钟
     */
    FOUR_M(8),
    /**
     * 5分钟
     */
    FIVE_M(9),
    /**
     * 6分钟
     */
    SIX_M(10),
    /**
     * 7分钟
     */
    SEVEN_M(11),
    /**
     * 8分钟
     */
    EIGHT_M(12),
    /**
     * 9分钟
     */
    NINE_M(13),
    /**
     * 10分钟
     */
    TEN_M(14),
    /**
     * 20分钟
     */
    TWENTY_M(15),
    /**
     * 30分钟
     */
    THIRTY_M(16),
    /**
     * 1小时
     */
    ONE_H(17),
    /**
     * 2小时
     */
    TWO_H(18);

    MessageDelayLevel(int value) {
        this.value = value;
    }

    private int value;

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}
