/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.property.PropertyNamer;

public abstract class AbstractLambdaWrapper<T, Children extends AbstractLambdaWrapper<T, Children>>
extends AbstractWrapper<T, SFunction<T, ?>, Children> {
    @Override
    protected void initEntityClass() {
        super.initEntityClass();
    }

    protected String columnsToString(SFunction<T, ?> ... columns) {
        return this.columnsToString(true, columns);
    }

    protected String columnsToString(boolean onlyColumn, SFunction<T, ?> ... columns) {
        return Arrays.stream(columns).map(i -> this.columnToString((SFunction<T, ?>)i, onlyColumn)).collect(Collectors.joining(","));
    }

    @Override
    protected String columnToString(SFunction<T, ?> column) {
        return this.columnToString(column, true);
    }

    protected String columnToString(SFunction<T, ?> column, boolean onlyColumn) {
        return this.getColumn(LambdaUtils.resolve(column), onlyColumn);
    }

    private String getColumn(SerializedLambda lambda, boolean onlyColumn) throws MybatisPlusException {
        String fieldName = PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
        return Optional.ofNullable(LambdaUtils.getColumnOfProperty(lambda.getInstantiatedMethodType(), fieldName)).map(onlyColumn ? ColumnCache::getColumn : ColumnCache::getColumnSelect).orElseThrow(() -> ExceptionUtils.mpe("Your property named \"%s\" cannot find the corresponding database column name!", fieldName));
    }
}

