/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import java.lang.reflect.Field;

public class TableFieldInfo
implements Constants {
    private final boolean related;
    private final String column;
    private final String property;
    private final String el;
    private final Class<?> propertyType;
    private final boolean isCharSequence;
    private final FieldStrategy fieldStrategy;
    private boolean select = true;
    private boolean version;
    private String logicDeleteValue;
    private String logicNotDeleteValue;
    private String update;
    private String condition = "%s=#{%s}";
    private FieldFill fieldFill = FieldFill.DEFAULT;
    private String sqlSelect;

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, String column, String el, TableField tableField) {
        this.version = field.getAnnotation(Version.class) != null;
        this.property = field.getName();
        this.propertyType = field.getType();
        this.isCharSequence = StringUtils.isCharSequence(this.propertyType);
        this.fieldFill = tableField.fill();
        this.update = tableField.update();
        this.el = el;
        tableInfo.setLogicDelete(this.initLogicDelete(dbConfig, field));
        if (StringUtils.isEmpty(tableField.value()) && tableInfo.isUnderCamel()) {
            column = StringUtils.camelToUnderline(column);
        }
        this.column = column;
        this.related = TableInfoHelper.checkRelated(tableInfo.isUnderCamel(), this.property, this.column);
        this.fieldStrategy = tableField.strategy() == FieldStrategy.DEFAULT ? dbConfig.getFieldStrategy() : tableField.strategy();
        if (StringUtils.isNotEmpty(tableField.condition())) {
            this.condition = tableField.condition();
        } else {
            this.setCondition(dbConfig);
        }
        this.select = tableField.select();
    }

    public TableFieldInfo(GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field) {
        String columnFormat;
        this.version = field.getAnnotation(Version.class) != null;
        this.property = field.getName();
        this.propertyType = field.getType();
        this.isCharSequence = StringUtils.isCharSequence(this.propertyType);
        this.el = field.getName();
        this.fieldStrategy = dbConfig.getFieldStrategy();
        this.setCondition(dbConfig);
        tableInfo.setLogicDelete(this.initLogicDelete(dbConfig, field));
        String column = field.getName();
        if (tableInfo.isUnderCamel()) {
            column = StringUtils.camelToUnderline(column);
        }
        if (dbConfig.isCapitalMode()) {
            column = column.toUpperCase();
        }
        if (StringUtils.isNotEmpty(columnFormat = dbConfig.getColumnFormat())) {
            column = String.format(columnFormat, column);
        }
        this.column = column;
        this.related = TableInfoHelper.checkRelated(tableInfo.isUnderCamel(), this.property, this.column);
    }

    private boolean initLogicDelete(GlobalConfig.DbConfig dbConfig, Field field) {
        TableLogic tableLogic = field.getAnnotation(TableLogic.class);
        if (null != tableLogic) {
            this.logicNotDeleteValue = StringUtils.isNotEmpty(tableLogic.value()) ? tableLogic.value() : dbConfig.getLogicNotDeleteValue();
            this.logicDeleteValue = StringUtils.isNotEmpty(tableLogic.delval()) ? tableLogic.delval() : dbConfig.getLogicDeleteValue();
            return true;
        }
        return false;
    }

    public boolean isLogicDelete() {
        return StringUtils.isNotEmpty(this.logicDeleteValue);
    }

    private void setCondition(GlobalConfig.DbConfig dbConfig) {
        if ((null == this.condition || "%s=#{%s}".equals(this.condition)) && dbConfig.isColumnLike() && this.isCharSequence) {
            this.condition = dbConfig.getDbType().getLike();
        }
    }

    public String getSqlSelect() {
        if (this.sqlSelect != null) {
            return this.sqlSelect;
        }
        this.sqlSelect = this.column;
        if (this.related) {
            this.sqlSelect = this.sqlSelect + " AS " + this.property;
        }
        return this.sqlSelect;
    }

    public String getInsertSqlProperty(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return SqlScriptUtils.safeParam(newPrefix + this.el) + ",";
    }

    public String getInsertSqlPropertyMaybeIf(String prefix) {
        String sqlScript = this.getInsertSqlProperty(prefix);
        if (this.fieldFill == FieldFill.INSERT || this.fieldFill == FieldFill.INSERT_UPDATE) {
            return sqlScript;
        }
        return this.convertIf(sqlScript, this.property);
    }

    public String getInsertSqlColumn() {
        return this.column + ",";
    }

    public String getInsertSqlColumnMaybeIf() {
        String sqlScript = this.getInsertSqlColumn();
        if (this.fieldFill == FieldFill.INSERT || this.fieldFill == FieldFill.INSERT_UPDATE) {
            return sqlScript;
        }
        return this.convertIf(sqlScript, this.property);
    }

    public String getSqlSet(String prefix) {
        return this.getSqlSet(false, prefix);
    }

    public String getSqlSet(boolean ignoreIf, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlSet = this.column + "=";
        sqlSet = StringUtils.isNotEmpty(this.update) ? sqlSet + String.format(this.update, this.column) : sqlSet + SqlScriptUtils.safeParam(newPrefix + this.el);
        sqlSet = sqlSet + ",";
        if (ignoreIf) {
            return sqlSet;
        }
        if (this.fieldFill == FieldFill.UPDATE || this.fieldFill == FieldFill.INSERT_UPDATE) {
            return sqlSet;
        }
        return this.convertIf(sqlSet, newPrefix + this.property);
    }

    public String getSqlWhere(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlScript = " AND " + String.format(this.condition, this.column, newPrefix + this.el);
        return this.convertIf(sqlScript, newPrefix + this.property);
    }

    private String convertIf(String sqlScript, String property) {
        if (this.fieldStrategy == FieldStrategy.IGNORED) {
            return sqlScript;
        }
        if (this.fieldStrategy == FieldStrategy.NOT_EMPTY && this.isCharSequence) {
            return SqlScriptUtils.convertIf(sqlScript, String.format("%s != null and %s != ''", property, property), false);
        }
        return SqlScriptUtils.convertIf(sqlScript, String.format("%s != null", property), false);
    }

    public boolean isRelated() {
        return this.related;
    }

    public String getColumn() {
        return this.column;
    }

    public String getProperty() {
        return this.property;
    }

    public String getEl() {
        return this.el;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public boolean isCharSequence() {
        return this.isCharSequence;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    public boolean isSelect() {
        return this.select;
    }

    public boolean isVersion() {
        return this.version;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getCondition() {
        return this.condition;
    }

    public FieldFill getFieldFill() {
        return this.fieldFill;
    }

    public String toString() {
        return "TableFieldInfo(related=" + this.isRelated() + ", column=" + this.getColumn() + ", property=" + this.getProperty() + ", el=" + this.getEl() + ", propertyType=" + this.getPropertyType() + ", isCharSequence=" + this.isCharSequence() + ", fieldStrategy=" + this.getFieldStrategy() + ", select=" + this.isSelect() + ", version=" + this.isVersion() + ", logicDeleteValue=" + this.getLogicDeleteValue() + ", logicNotDeleteValue=" + this.getLogicNotDeleteValue() + ", update=" + this.getUpdate() + ", condition=" + this.getCondition() + ", fieldFill=" + this.getFieldFill() + ", sqlSelect=" + this.getSqlSelect() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableFieldInfo)) {
            return false;
        }
        TableFieldInfo other = (TableFieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRelated() != other.isRelated()) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$el = this.getEl();
        String other$el = other.getEl();
        if (this$el == null ? other$el != null : !this$el.equals(other$el)) {
            return false;
        }
        Class<?> this$propertyType = this.getPropertyType();
        Class<?> other$propertyType = other.getPropertyType();
        if (this$propertyType == null ? other$propertyType != null : !this$propertyType.equals(other$propertyType)) {
            return false;
        }
        if (this.isCharSequence() != other.isCharSequence()) {
            return false;
        }
        FieldStrategy this$fieldStrategy = this.getFieldStrategy();
        FieldStrategy other$fieldStrategy = other.getFieldStrategy();
        if (this$fieldStrategy == null ? other$fieldStrategy != null : !this$fieldStrategy.equals(other$fieldStrategy)) {
            return false;
        }
        if (this.isSelect() != other.isSelect()) {
            return false;
        }
        if (this.isVersion() != other.isVersion()) {
            return false;
        }
        String this$logicDeleteValue = this.getLogicDeleteValue();
        String other$logicDeleteValue = other.getLogicDeleteValue();
        if (this$logicDeleteValue == null ? other$logicDeleteValue != null : !this$logicDeleteValue.equals(other$logicDeleteValue)) {
            return false;
        }
        String this$logicNotDeleteValue = this.getLogicNotDeleteValue();
        String other$logicNotDeleteValue = other.getLogicNotDeleteValue();
        if (this$logicNotDeleteValue == null ? other$logicNotDeleteValue != null : !this$logicNotDeleteValue.equals(other$logicNotDeleteValue)) {
            return false;
        }
        String this$update = this.getUpdate();
        String other$update = other.getUpdate();
        if (this$update == null ? other$update != null : !this$update.equals(other$update)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        FieldFill this$fieldFill = this.getFieldFill();
        FieldFill other$fieldFill = other.getFieldFill();
        if (this$fieldFill == null ? other$fieldFill != null : !this$fieldFill.equals(other$fieldFill)) {
            return false;
        }
        String this$sqlSelect = this.getSqlSelect();
        String other$sqlSelect = other.getSqlSelect();
        return !(this$sqlSelect == null ? other$sqlSelect != null : !this$sqlSelect.equals(other$sqlSelect));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableFieldInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRelated() ? 79 : 97);
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $el = this.getEl();
        result = result * 59 + ($el == null ? 43 : $el.hashCode());
        Class<?> $propertyType = this.getPropertyType();
        result = result * 59 + ($propertyType == null ? 43 : $propertyType.hashCode());
        result = result * 59 + (this.isCharSequence() ? 79 : 97);
        FieldStrategy $fieldStrategy = this.getFieldStrategy();
        result = result * 59 + ($fieldStrategy == null ? 43 : $fieldStrategy.hashCode());
        result = result * 59 + (this.isSelect() ? 79 : 97);
        result = result * 59 + (this.isVersion() ? 79 : 97);
        String $logicDeleteValue = this.getLogicDeleteValue();
        result = result * 59 + ($logicDeleteValue == null ? 43 : $logicDeleteValue.hashCode());
        String $logicNotDeleteValue = this.getLogicNotDeleteValue();
        result = result * 59 + ($logicNotDeleteValue == null ? 43 : $logicNotDeleteValue.hashCode());
        String $update = this.getUpdate();
        result = result * 59 + ($update == null ? 43 : $update.hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        FieldFill $fieldFill = this.getFieldFill();
        result = result * 59 + ($fieldFill == null ? 43 : $fieldFill.hashCode());
        String $sqlSelect = this.getSqlSelect();
        result = result * 59 + ($sqlSelect == null ? 43 : $sqlSelect.hashCode());
        return result;
    }
}

