/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.dts.sender;

import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.dts.DtsMeta;
import com.baomidou.mybatisplus.dts.parser.IDtsParser;
import com.baomidou.mybatisplus.dts.sender.IRmtSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitRmtSender
implements IRmtSender {
    private static final Logger log = LoggerFactory.getLogger(RabbitRmtSender.class);
    @Autowired
    private IDtsParser rmtParser;
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void send(DtsMeta dtsMeta) {
        String object = null;
        try {
            object = this.rmtParser.toJSONString(dtsMeta);
            this.rabbitTemplate.convertAndSend("dts-rmt-exchange", "dts-rmt-routingkey", (Object)object);
        }
        catch (AmqpException e) {
            ExceptionUtils.mpe((String)"rabbit send error, dtsMeta: %s", (Throwable)e, (Object[])new Object[]{object});
        }
        catch (Exception e) {
            ExceptionUtils.mpe((String)"rmt parser error, dtsMeta.event: %s", (Throwable)e, (Object[])new Object[]{dtsMeta.getEvent()});
        }
    }
}

