package ${package.Controller};

import org.springframework.web.bind.annotation.RequestMapping;
<#if genCRUDFlag>
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import ${package.Service}.${table.serviceName};
import ${package.Entity}.${entity};

import java.util.ArrayList;
import java.util.List;
</#if>
<#if restControllerStyle>
import org.springframework.web.bind.annotation.RestController;
<#else>
import org.springframework.stereotype.Controller;
</#if>
<#if superControllerClassPackage??>
import ${superControllerClassPackage};
</#if>
import lombok.extern.slf4j.Slf4j;
/**
 * <p>
 * ${table.comment!} 前端控制器
 * </p>
 *
 * @author ${author}
 * @since ${date}
 */
<#if genCRUDFlag>
@Api(description = "${table.comment!}控制器")
</#if>
@Slf4j
<#if restControllerStyle>
@RestController
<#else>
@Controller
</#if>
@RequestMapping("<#if package.ModuleName??>/${package.ModuleName}</#if>/<#if controllerMappingHyphenStyle??>${controllerMappingHyphen}<#else>${table.entityPath}</#if>")
<#if kotlin>
class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
<#if superControllerClass??>
public class ${table.controllerName} extends ${superControllerClass} {
<#else>
public class ${table.controllerName} {
    <#if genCRUDFlag>

    @Autowired
    ${table.serviceName} i${entity}Service;

    @ApiOperation(value = "新增", httpMethod = "POST")
    @PostMapping(value = "/create")
    public int ${table.entityPath}Save(${entity} ${table.entityPath})  {
        Assert.notNull(${table.entityPath}, "Object must have value");
        int count = 0;
        try {
            count = i${entity}Service.save(${table.entityPath}) ? 1 : 0;
        } catch (Exception e) {
            log.error("${table.entityPath}Save -=- {}",e.toString());
        }
        return count;
    }

    @ApiOperation(value = "批量新增", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "新增数量", value = "${table.entityPath}Count", dataType = "int", paramType = "query")})
    @PostMapping(value = "/createBatch")
    public boolean createDemos(@RequestParam("${table.entityPath}Count") int ${table.entityPath}Count,${entity} ${table.entityPath}) {
       List<${entity}> ${table.entityPath}List = new ArrayList<>(5);
        Assert.notNull(${table.entityPath}, "Object must have value");
        Assert.notNull(${table.entityPath}Count, "${table.entityPath}Count  must have value");
        for (int i = 0; i < 5; i++) {
            ${table.entityPath}List.add(${table.entityPath});
        }
        return i${entity}Service.saveBatch(${table.entityPath}List);
    }

    @ApiOperation(value = "修改", httpMethod = "POST")
    @PostMapping(value = "/update")
    public int ${table.entityPath}Update(${entity} ${table.entityPath})  {
        Assert.notNull(${table.entityPath}, "Object must have value");
        int count = 0;
        try {
            count = i${entity}Service.saveOrUpdate(${table.entityPath}) ? 1 : 0;
        } catch (Exception e) {
            log.error("${table.entityPath}Update -=- {}",e.toString());
        }
        return count;
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @PostMapping(value = "/delete")
    public int ${table.entityPath}Delete(${entity} ${table.entityPath})  {
        int count = 0;
        try {
            count = i${entity}Service.deleteByEntity(${table.entityPath}) ? 1 : 0;
        } catch (Exception e) {
            log.error("${table.entityPath}Delete -=- {}",e.toString());
        }
        return count;
    }

    @ApiOperation(value = "查询", httpMethod = "POST")
    @PostMapping(value = "/query")
    public ${entity} ${table.entityPath}Query(${entity} ${table.entityPath})  {
        ${entity} ${table.entityPath}Result = new ${entity}();
        try {
            ${table.entityPath}Result = i${entity}Service.queryByEntity(${table.entityPath});
        } catch (Exception e) {
            log.error("${table.entityPath}Query -=- {}",e.toString());
        }
        return  ${table.entityPath}Result ;
    }

    @ApiOperation(value = "分页查询", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "页码", value = "page", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "页数", value = "limit", dataType = "int", paramType = "query")
    })
    @GetMapping(value = "/queryPage")
    public IPage<${entity}> query${entity}Page(@RequestParam("page") int page, @RequestParam("limit") int limit) {
        Assert.notNull(page<=0, "页码必须大于0");
        Assert.notNull(limit, "limit  must have value");

        return  i${entity}Service.query${entity}Page(page,limit);
    }

    @ApiOperation(value = "分页查询根据实体", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "页码", value = "page", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "页数", value = "limit", dataType = "int", paramType = "query")
    })
    @PostMapping(value = "/queryPageByEntity")
    public IPage<${entity}> query${entity}PageByEntity(@RequestParam("page") int page, @RequestParam("limit") int limit,${entity} ${table.entityPath}) {
        Assert.notNull(page<=0, "页码必须大于0");
        Assert.notNull(limit, "limit  must have value");
        Assert.notNull(${table.entityPath}, "Object must have value");
        return  i${entity}Service.query${entity}PageByEntity(page,limit,${table.entityPath});
    }
    </#if>
</#if>

}
</#if>
