/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.minio.oss.config;

import com.sinosoftgz.starter.minio.oss.properties.MinioProperties;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.PostConstruct;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={})
@EnableConfigurationProperties(value={MinioProperties.class})
@ConditionalOnProperty(prefix="oss.minio", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={MinioClient.class})
public class MinioConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MinioConfiguration.class);
    @Autowired
    private MinioProperties minioProperties;

    @Bean
    @ConditionalOnMissingBean
    MinioClient minioClient(OkHttpClient okHttpClient) {
        log.info("init the minio client user args :{}", (Object)this.minioProperties);
        MinioClient client = MinioClient.builder().httpClient(okHttpClient).credentials(this.minioProperties.getAccessKey(), this.minioProperties.getSecretKey()).endpoint(this.minioProperties.getUrl()).build();
        client.setTimeout(this.minioProperties.getConnectTimeout().toMinutes(), this.minioProperties.getWriteTimeout().toMinutes(), this.minioProperties.getReadTimeout().toMinutes());
        return client;
    }

    @Bean
    @ConditionalOnMissingBean(value={OkHttpClient.class})
    OkHttpClient httpClient() {
        log.info("minio init by the default http client");
        return new OkHttpClient.Builder().build();
    }

    @PostConstruct
    void init() throws IOException, InvalidKeyException, InvalidResponseException, InsufficientDataException, NoSuchAlgorithmException, ServerException, InternalException, XmlParserException, ErrorResponseException {
        MinioClient minioClient;
        boolean bucketExists;
        if (this.minioProperties.getBucket() == null || "".equals(this.minioProperties.getBucket().trim())) {
            return;
        }
        if (this.minioProperties.isCreateBucket() && !(bucketExists = (minioClient = this.minioClient(this.httpClient())).bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.minioProperties.getBucket())).build()))) {
            log.info("create minio bucket : {} ", (Object)this.minioProperties.getBucket());
            minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.minioProperties.getBucket())).build());
        }
    }
}

