package com.sinosoftgz.starter.nacos.discovery.properties;

import com.sinosoftgz.starter.nacos.discovery.constant.DevNacosConstants;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author: Roney
 * @date: 2021-12-14 11:12
 * @description: NacosDiscoveryProperties
 */

@ConfigurationProperties(prefix = SinoNacosDiscoveryProperties.NACOS_DISCOVERY_PREFIX)
@Data
public class SinoNacosDiscoveryProperties {
    public static final String NACOS_DISCOVERY_PREFIX = "nacos.discovery";

    /**
     * 是否开启开发环境配置
     * 默认不开启
     */
    private boolean devEnabled = false;

    /**
     * 测试环境IP前缀，用于优先调用
     */
    private String testIpPrefix = DevNacosConstants.START_SIT_IP;
}
