/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.admin.model.dto.BalancingDTO;
import org.apache.dubbo.admin.model.dto.DynamicConfigDTO;
import org.apache.dubbo.admin.model.dto.WeightDTO;
import org.apache.dubbo.admin.model.store.OverrideConfig;
import org.apache.dubbo.admin.model.store.OverrideDTO;

public class OverrideUtils {
    public static OverrideConfig weightDTOtoConfig(WeightDTO weightDTO) {
        OverrideConfig overrideConfig = new OverrideConfig();
        overrideConfig.setType("weight");
        overrideConfig.setEnabled(true);
        overrideConfig.setSide("provider");
        overrideConfig.setAddresses(weightDTO.getAddresses());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("weight", weightDTO.getWeight());
        overrideConfig.setParameters(parameters);
        return overrideConfig;
    }

    public static OverrideConfig balancingDTOtoConfig(BalancingDTO balancingDTO) {
        OverrideConfig overrideConfig = new OverrideConfig();
        overrideConfig.setType("balancing");
        overrideConfig.setEnabled(true);
        overrideConfig.setSide("consumer");
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (balancingDTO.getMethodName().equals("*")) {
            parameters.put("loadbalance", balancingDTO.getStrategy());
        } else {
            parameters.put(balancingDTO.getMethodName() + ".loadbalance", balancingDTO.getStrategy());
        }
        overrideConfig.setParameters(parameters);
        return overrideConfig;
    }

    public static DynamicConfigDTO createFromOverride(OverrideDTO overrideDTO) {
        DynamicConfigDTO dynamicConfigDTO = new DynamicConfigDTO();
        dynamicConfigDTO.setConfigVersion(overrideDTO.getConfigVersion());
        ArrayList<OverrideConfig> configs = new ArrayList<OverrideConfig>();
        for (OverrideConfig overrideConfig : overrideDTO.getConfigs()) {
            if (overrideConfig.getType() != null) continue;
            configs.add(overrideConfig);
        }
        if (configs.size() == 0) {
            return null;
        }
        dynamicConfigDTO.setConfigs(configs);
        if (overrideDTO.getScope().equals("application")) {
            dynamicConfigDTO.setApplication(overrideDTO.getKey());
        } else {
            dynamicConfigDTO.setService(overrideDTO.getKey());
        }
        dynamicConfigDTO.setEnabled(overrideDTO.isEnabled());
        return dynamicConfigDTO;
    }

    public static WeightDTO configtoWeightDTO(OverrideConfig config, String scope, String key) {
        WeightDTO weightDTO = new WeightDTO();
        if (scope.equals("application")) {
            weightDTO.setApplication(key);
        } else {
            weightDTO.setService(key);
        }
        weightDTO.setWeight(((Integer)config.getParameters().get("weight")).intValue());
        weightDTO.setAddresses(config.getAddresses());
        return weightDTO;
    }

    public static BalancingDTO configtoBalancingDTO(OverrideConfig config, String scope, String key) {
        BalancingDTO balancingDTO = new BalancingDTO();
        if (scope.equals("application")) {
            balancingDTO.setApplication(key);
        } else {
            balancingDTO.setService(key);
        }
        for (Map.Entry entry : config.getParameters().entrySet()) {
            String k = (String)entry.getKey();
            String method = k.contains(".") ? k.split("\\.")[0] : "*";
            balancingDTO.setMethodName(method);
            balancingDTO.setStrategy((String)entry.getValue());
        }
        return balancingDTO;
    }
}

