/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.common.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.admin.common.util.RouteUtils;
import org.apache.dubbo.admin.model.domain.Route;
import org.apache.dubbo.admin.model.dto.AccessDTO;
import org.apache.dubbo.admin.model.dto.ConditionRouteDTO;
import org.apache.dubbo.admin.model.dto.TagRouteDTO;
import org.apache.dubbo.admin.model.store.RoutingRule;
import org.apache.dubbo.admin.model.store.TagRoute;
import org.apache.dubbo.common.utils.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RouteUtils {
    static RouteUtils EMPTY = new RouteUtils(Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    private static Pattern ROUTE_PATTERN = Pattern.compile("([&!=,]*)\\s*([^&!=,\\s]+)");
    private static Pattern CONDITION_SEPERATOR = Pattern.compile("(.*)=>(.*)");
    private static Pattern VALUE_LIST_SEPARATOR = Pattern.compile("\\s*,\\s*");
    final Map<String, MatchPair> whenCondition;
    final Map<String, MatchPair> thenCondition;
    private volatile String tostring = null;

    private RouteUtils(Map<String, MatchPair> when, Map<String, MatchPair> then) {
        for (Map.Entry<String, MatchPair> entry : when.entrySet()) {
            entry.getValue().freeze();
        }
        for (Map.Entry<String, MatchPair> entry : then.entrySet()) {
            entry.getValue().freeze();
        }
        this.whenCondition = when;
        this.thenCondition = then;
    }

    public static Map<String, MatchPair> parseRule(String rule) throws ParseException {
        HashMap<String, MatchPair> condition = new HashMap<String, MatchPair>();
        if (StringUtils.isBlank((CharSequence)rule)) {
            return condition;
        }
        MatchPair pair = null;
        Set values = null;
        Matcher matcher = ROUTE_PATTERN.matcher(rule);
        while (matcher.find()) {
            String separator = matcher.group(1);
            String content = matcher.group(2);
            if (separator == null || separator.length() == 0) {
                pair = new MatchPair();
                condition.put(content, pair);
                continue;
            }
            if ("&".equals(separator)) {
                if (condition.get(content) == null) {
                    pair = new MatchPair();
                    condition.put(content, pair);
                    continue;
                }
                condition.put(content, pair);
                continue;
            }
            if ("=".equals(separator)) {
                if (pair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = pair.matches;
                values.add(content);
                continue;
            }
            if ("!=".equals(separator)) {
                if (pair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = pair.unmatches;
                values.add(content);
                continue;
            }
            if (",".equals(separator)) {
                if (values == null || values.size() == 0) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values.add(content);
                continue;
            }
            throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
        }
        return condition;
    }

    public static RouteUtils parse(Route conditionRoute) throws ParseException {
        if (conditionRoute == null) {
            throw new ParseException("null conditionRoute!", 0);
        }
        if (conditionRoute.getMatchRule() == null && conditionRoute.getFilterRule() == null) {
            return RouteUtils.parse((String)conditionRoute.getRule());
        }
        return RouteUtils.parse((String)(conditionRoute == null ? null : conditionRoute.getMatchRule()), (String)(conditionRoute == null ? null : conditionRoute.getFilterRule()));
    }

    public static RouteUtils parse(String whenRule, String thenRule) throws ParseException {
        if (thenRule == null || thenRule.trim().length() == 0) {
            throw new ParseException("Illegal route rule without then express", 0);
        }
        Map when = RouteUtils.parseRule((String)whenRule.trim());
        Map then = RouteUtils.parseRule((String)thenRule.trim());
        return new RouteUtils(when, then);
    }

    public static RouteUtils parse(String rule) throws ParseException {
        if (StringUtils.isBlank((CharSequence)rule)) {
            throw new ParseException("Illegal blank route rule", 0);
        }
        Matcher matcher = CONDITION_SEPERATOR.matcher(rule);
        if (!matcher.matches()) {
            throw new ParseException("condition seperator => not found!", 0);
        }
        return RouteUtils.parse((String)matcher.group(1), (String)matcher.group(2));
    }

    public static RouteUtils parseQuitely(Route conditionRoute) {
        try {
            return RouteUtils.parse((Route)conditionRoute);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static TagRoute convertTagroutetoStore(TagRouteDTO tagRoute) {
        TagRoute store = new TagRoute();
        store.setKey(tagRoute.getApplication());
        store.setEnabled(tagRoute.isEnabled());
        store.setForce(tagRoute.isForce());
        store.setPriority(tagRoute.getPriority());
        store.setRuntime(tagRoute.isRuntime());
        store.setTags(tagRoute.getTags());
        return store;
    }

    public static TagRouteDTO convertTagroutetoDisplay(TagRoute tagRoute) {
        TagRouteDTO tagRouteDTO = new TagRouteDTO();
        tagRouteDTO.setApplication(tagRoute.getKey());
        tagRouteDTO.setRuntime(tagRoute.isRuntime());
        tagRouteDTO.setPriority(tagRoute.getPriority());
        tagRouteDTO.setTags(tagRoute.getTags());
        tagRouteDTO.setForce(tagRoute.isForce());
        tagRouteDTO.setEnabled(tagRoute.isEnabled());
        return tagRouteDTO;
    }

    public static RoutingRule insertConditionRule(RoutingRule existRule, ConditionRouteDTO conditionRoute) {
        if (existRule == null) {
            existRule = new RoutingRule();
            if (StringUtils.isNotEmpty((String)conditionRoute.getApplication())) {
                existRule.setKey(conditionRoute.getApplication());
                existRule.setScope("application");
            } else {
                existRule.setKey(conditionRoute.getService().replace("/", "*"));
                existRule.setScope("service");
            }
        }
        existRule.setConditions(conditionRoute.getConditions());
        existRule.setEnabled(conditionRoute.isEnabled());
        existRule.setForce(conditionRoute.isForce());
        existRule.setRuntime(conditionRoute.isRuntime());
        existRule.setPriority(conditionRoute.getPriority());
        return existRule;
    }

    public static List<String> convertToBlackWhiteList(AccessDTO accessDTO) {
        StringBuilder sb;
        if (accessDTO == null) {
            return null;
        }
        Set whiteList = accessDTO.getWhitelist();
        Set blackList = accessDTO.getBlacklist();
        ArrayList<String> conditions = new ArrayList<String>();
        if (whiteList != null && whiteList.size() > 0) {
            sb = new StringBuilder();
            sb.append("host != ");
            for (String white : whiteList) {
                sb.append(white).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" =>");
            conditions.add(sb.toString());
        }
        if (blackList != null && blackList.size() > 0) {
            sb = new StringBuilder();
            sb.append("host = ");
            for (String black : blackList) {
                sb.append(black).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" =>");
            conditions.add(sb.toString());
        }
        return conditions;
    }

    public static List<String> filterBlackWhiteListFromConditions(List<String> conditions) {
        ArrayList<String> result = new ArrayList<String>();
        if (conditions == null || conditions.isEmpty()) {
            return result;
        }
        for (String condition : conditions) {
            if (RouteUtils.isBlackList((String)condition)) {
                result.add(condition);
                continue;
            }
            if (!RouteUtils.isWhiteList((String)condition)) continue;
            result.add(condition);
        }
        return result;
    }

    public static List<String> filterConditionRuleFromConditions(List<String> conditions) {
        ArrayList<String> result = new ArrayList<String>();
        if (conditions == null || conditions.isEmpty()) {
            return result;
        }
        for (String condition : conditions) {
            if (RouteUtils.isBlackList((String)condition) || RouteUtils.isWhiteList((String)condition)) continue;
            result.add(condition);
        }
        return result;
    }

    public static AccessDTO convertToAccessDTO(List<String> blackWhiteList, String scope, String key) {
        if (blackWhiteList == null) {
            return null;
        }
        AccessDTO accessDTO = new AccessDTO();
        if (scope.equals("application")) {
            accessDTO.setApplication(key);
        } else {
            accessDTO.setService(key);
        }
        if (blackWhiteList != null) {
            for (String condition : blackWhiteList) {
                if (condition.contains("host != ")) {
                    condition = org.apache.commons.lang3.StringUtils.substringBetween((String)condition, (String)"host !=", (String)" =>").trim();
                    accessDTO.setWhitelist(new HashSet<String>(Arrays.asList(condition.split(","))));
                }
                if (!condition.contains("host = ")) continue;
                condition = org.apache.commons.lang3.StringUtils.substringBetween((String)condition, (String)"host =", (String)" =>").trim();
                accessDTO.setBlacklist(new HashSet<String>(Arrays.asList(condition.split(","))));
            }
        }
        return accessDTO;
    }

    public static Route convertAccessDTOtoRoute(AccessDTO accessDTO) {
        Route route = new Route();
        route.setService(accessDTO.getService());
        route.setForce(true);
        route.setFilterRule("false");
        route.setEnabled(true);
        HashMap<String, MatchPair> when = new HashMap<String, MatchPair>();
        MatchPair matchPair = new MatchPair(new HashSet(), new HashSet());
        when.put("host", matchPair);
        if (accessDTO.getWhitelist() != null) {
            matchPair.getUnmatches().addAll(accessDTO.getWhitelist());
        }
        if (accessDTO.getBlacklist() != null) {
            matchPair.getMatches().addAll(accessDTO.getBlacklist());
        }
        StringBuilder sb = new StringBuilder();
        RouteUtils.contidionToString((StringBuilder)sb, when);
        route.setMatchRule(sb.toString());
        return route;
    }

    public static ConditionRouteDTO createConditionRouteFromRule(RoutingRule routingRule) {
        ConditionRouteDTO conditionRouteDTO = new ConditionRouteDTO();
        if (routingRule.getScope().equals("service")) {
            conditionRouteDTO.setService(routingRule.getKey());
        } else {
            conditionRouteDTO.setApplication(routingRule.getKey());
        }
        conditionRouteDTO.setConditions(RouteUtils.filterConditionRuleFromConditions((List)routingRule.getConditions()));
        conditionRouteDTO.setPriority(routingRule.getPriority());
        conditionRouteDTO.setEnabled(routingRule.isEnabled());
        conditionRouteDTO.setForce(routingRule.isForce());
        conditionRouteDTO.setRuntime(routingRule.isRuntime());
        return conditionRouteDTO;
    }

    public static Route convertBlackWhiteListtoRoute(List<String> blackWhiteList, String scope, String key) {
        AccessDTO accessDTO = RouteUtils.convertToAccessDTO(blackWhiteList, (String)scope, (String)key);
        return RouteUtils.convertAccessDTOtoRoute((AccessDTO)accessDTO);
    }

    static Map<String, MatchPair> parseNameAndValueListString2Condition(Map<String, String> params, Map<String, String> notParams) {
        HashSet<String> set;
        String[] list;
        String valueListString;
        HashMap<String, MatchPair> condition = new HashMap<String, MatchPair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            valueListString = entry.getValue();
            if (StringUtils.isBlank((CharSequence)valueListString)) continue;
            list = VALUE_LIST_SEPARATOR.split(valueListString);
            set = new HashSet<String>();
            String[] stringArray = list;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String item = stringArray[i];
                if (StringUtils.isBlank((CharSequence)item)) continue;
                set.add(item.trim());
            }
            if (set.isEmpty()) continue;
            String string = entry.getKey();
            MatchPair matchPair = (MatchPair)condition.get(string);
            if (null == matchPair) {
                matchPair = new MatchPair();
                condition.put(string, matchPair);
            }
            matchPair.matches = set;
        }
        for (Map.Entry<String, String> entry : notParams.entrySet()) {
            valueListString = entry.getValue();
            if (StringUtils.isBlank((CharSequence)valueListString)) continue;
            list = VALUE_LIST_SEPARATOR.split(valueListString);
            set = new HashSet();
            for (String item : list) {
                if (StringUtils.isBlank((CharSequence)item)) continue;
                set.add(item.trim());
            }
            if (set.isEmpty()) continue;
            String string = entry.getKey();
            MatchPair matchPair = (MatchPair)condition.get(string);
            if (null == matchPair) {
                matchPair = new MatchPair();
                condition.put(string, matchPair);
            }
            matchPair.unmatches = set;
        }
        return condition;
    }

    public static RouteUtils createFromNameAndValueListString(Map<String, String> whenParams, Map<String, String> notWhenParams, Map<String, String> thenParams, Map<String, String> notThenParams) {
        Map when = RouteUtils.parseNameAndValueListString2Condition(whenParams, notWhenParams);
        Map then = RouteUtils.parseNameAndValueListString2Condition(thenParams, notThenParams);
        return new RouteUtils(when, then);
    }

    public static RouteUtils createFromCondition(Map<String, MatchPair> whenCondition, Map<String, MatchPair> thenCondition) {
        return new RouteUtils(whenCondition, thenCondition);
    }

    public static RouteUtils copyWithRemove(RouteUtils copy, Set<String> whenParams, Set<String> thenParams) {
        HashMap when = new HashMap();
        for (Map.Entry entry : copy.getWhenCondition().entrySet()) {
            if (whenParams != null && whenParams.contains(entry.getKey())) continue;
            when.put(entry.getKey(), entry.getValue());
        }
        HashMap then = new HashMap();
        for (Map.Entry entry : copy.getThenCondition().entrySet()) {
            if (thenParams != null && thenParams.contains(entry.getKey())) continue;
            then.put(entry.getKey(), entry.getValue());
        }
        return new RouteUtils(when, then);
    }

    public static RouteUtils copyWithReplace(RouteUtils copy, Map<String, MatchPair> whenCondition, Map<String, MatchPair> thenCondition) {
        if (null == copy) {
            throw new NullPointerException("Argument copy is null!");
        }
        HashMap<String, MatchPair> when = new HashMap<String, MatchPair>();
        when.putAll(copy.getWhenCondition());
        if (whenCondition != null) {
            when.putAll(whenCondition);
        }
        HashMap<String, MatchPair> then = new HashMap<String, MatchPair>();
        then.putAll(copy.getThenCondition());
        if (thenCondition != null) {
            then.putAll(thenCondition);
        }
        return new RouteUtils(when, then);
    }

    static void join(StringBuilder sb, Set<String> valueSet) {
        boolean isFirst = true;
        for (String s : valueSet) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(s);
        }
    }

    public static boolean matchCondition(Map<String, String> sample, Map<String, MatchPair> condition) {
        for (Map.Entry<String, String> entry : sample.entrySet()) {
            String key = entry.getKey();
            MatchPair pair = condition.get(key);
            if (pair == null || pair.pass(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static String join(Set<String> valueSet) {
        StringBuilder sb = new StringBuilder(128);
        RouteUtils.join((StringBuilder)sb, valueSet);
        return sb.toString();
    }

    public static void contidionToString(StringBuilder sb, Map<String, MatchPair> condition) {
        boolean isFirst = true;
        for (Map.Entry<String, MatchPair> entry : condition.entrySet()) {
            String keyName = entry.getKey();
            MatchPair p = entry.getValue();
            Set[] setArray = new Set[]{p.matches, p.unmatches};
            String[] opArray = new String[]{" = ", " != "};
            for (int i = 0; i < setArray.length; ++i) {
                if (setArray[i].isEmpty()) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(" & ");
                }
                sb.append(keyName);
                sb.append(opArray[i]);
                RouteUtils.join((StringBuilder)sb, (Set)setArray[i]);
            }
        }
    }

    public boolean isWhenContainValue(String key, String value) {
        MatchPair matchPair = (MatchPair)this.whenCondition.get(key);
        if (null == matchPair) {
            return false;
        }
        return matchPair.containeValue(value);
    }

    public boolean isThenContainValue(String key, String value) {
        MatchPair matchPair = (MatchPair)this.thenCondition.get(key);
        if (null == matchPair) {
            return false;
        }
        return matchPair.containeValue(value);
    }

    public boolean isContainValue(String key, String value) {
        return this.isWhenContainValue(key, value) || this.isThenContainValue(key, value);
    }

    public Map<String, MatchPair> getWhenCondition() {
        return this.whenCondition;
    }

    public Map<String, MatchPair> getThenCondition() {
        return this.thenCondition;
    }

    public String getWhenConditionString() {
        StringBuilder sb = new StringBuilder(512);
        RouteUtils.contidionToString((StringBuilder)sb, (Map)this.whenCondition);
        return sb.toString();
    }

    public String getThenConditionString() {
        StringBuilder sb = new StringBuilder(512);
        RouteUtils.contidionToString((StringBuilder)sb, (Map)this.thenCondition);
        return sb.toString();
    }

    private static boolean isBlackList(String address) {
        return address.startsWith("host = ") && address.endsWith(" =>");
    }

    private static boolean isWhiteList(String address) {
        return address.startsWith("host != ") && address.endsWith(" =>");
    }

    public String toString() {
        if (this.tostring != null) {
            return this.tostring;
        }
        StringBuilder sb = new StringBuilder(512);
        RouteUtils.contidionToString((StringBuilder)sb, (Map)this.whenCondition);
        sb.append(" => ");
        RouteUtils.contidionToString((StringBuilder)sb, (Map)this.thenCondition);
        this.tostring = sb.toString();
        return this.tostring;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.thenCondition == null ? 0 : this.thenCondition.hashCode());
        result = 31 * result + (this.whenCondition == null ? 0 : this.whenCondition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RouteUtils other = (RouteUtils)obj;
        if (this.thenCondition == null ? other.thenCondition != null : !this.thenCondition.equals(other.thenCondition)) {
            return false;
        }
        return !(this.whenCondition == null ? other.whenCondition != null : !this.whenCondition.equals(other.whenCondition));
    }
}

