/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.model.domain.MethodMetadata;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceTestUtil {
    private static Pattern COLLECTION_PATTERN = Pattern.compile("^java\\.util\\..*(Set|List|Queue|Collection|Deque)(<.*>)*$");
    private static Pattern MAP_PATTERN = Pattern.compile("^java\\.util\\..*Map.*(<.*>)*$");

    public static boolean sameMethod(MethodDefinition m, String methodSig) {
        String name = m.getName();
        String[] parameters = m.getParameterTypes();
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("~");
        for (String parameter : parameters) {
            sb.append(parameter).append(";");
        }
        String sig = StringUtils.removeEnd((String)sb.toString(), (String)";");
        return sig.equals(methodSig);
    }

    public static MethodMetadata generateMethodMeta(FullServiceDefinition serviceDefinition, MethodDefinition methodDefinition) {
        MethodMetadata methodMetadata = new MethodMetadata();
        CharSequence[] parameterTypes = methodDefinition.getParameterTypes();
        String returnType = methodDefinition.getReturnType();
        String signature = methodDefinition.getName() + "~" + String.join((CharSequence)";", parameterTypes);
        methodMetadata.setSignature(signature);
        methodMetadata.setReturnType(returnType);
        List parameters = ServiceTestUtil.generateParameterTypes((String[])parameterTypes, (ServiceDefinition)serviceDefinition);
        methodMetadata.setParameterTypes(parameters);
        return methodMetadata;
    }

    private static boolean isPrimitiveType(TypeDefinition td) {
        String type = td.getType();
        return type.equals("byte") || type.equals("java.lang.Byte") || type.equals("short") || type.equals("java.lang.Short") || type.equals("int") || type.equals("java.lang.Integer") || type.equals("long") || type.equals("java.lang.Long") || type.equals("float") || type.equals("java.lang.Float") || type.equals("double") || type.equals("java.lang.Double") || type.equals("boolean") || type.equals("java.lang.Boolean") || type.equals("void") || type.equals("java.lang.Void") || type.equals("java.lang.String") || type.equals("java.util.Date") || type.equals("java.lang.Object");
    }

    private static List<Object> generateParameterTypes(String[] parameterTypes, ServiceDefinition serviceDefinition) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (String type : parameterTypes) {
            Object result = ServiceTestUtil.generateType((ServiceDefinition)serviceDefinition, (String)type);
            parameters.add(result);
        }
        return parameters;
    }

    private static TypeDefinition findTypeDefinition(ServiceDefinition serviceDefinition, String type) {
        return serviceDefinition.getTypes().stream().filter(t -> t.getType().equals(type)).findFirst().orElse(new TypeDefinition(type));
    }

    private static void generateComplexType(ServiceDefinition sd, TypeDefinition td, Map<String, Object> holder) {
        for (Map.Entry entry : td.getProperties().entrySet()) {
            if (ServiceTestUtil.isPrimitiveType((TypeDefinition)td)) {
                holder.put((String)entry.getKey(), ServiceTestUtil.generatePrimitiveType((TypeDefinition)td));
                continue;
            }
            ServiceTestUtil.generateEnclosedType(holder, (String)((String)entry.getKey()), (ServiceDefinition)sd, (TypeDefinition)((TypeDefinition)entry.getValue()));
        }
    }

    private static Object generateComplexType(ServiceDefinition sd, TypeDefinition td) {
        HashMap holder = new HashMap();
        ServiceTestUtil.generateComplexType((ServiceDefinition)sd, (TypeDefinition)td, holder);
        return holder;
    }

    private static boolean isMap(TypeDefinition td) {
        String type = StringUtils.substringBefore((String)td.getType(), (String)"<");
        Matcher matcher = MAP_PATTERN.matcher(type);
        return matcher.matches();
    }

    private static boolean isCollection(TypeDefinition td) {
        String type = StringUtils.substringBefore((String)td.getType(), (String)"<");
        Matcher matcher = COLLECTION_PATTERN.matcher(type);
        return matcher.matches();
    }

    private static boolean isArray(TypeDefinition td) {
        return StringUtils.endsWith((CharSequence)td.getType(), (CharSequence)"[]");
    }

    private static Object generatePrimitiveType(TypeDefinition td) {
        String type;
        switch (type = td.getType()) {
            case "byte": 
            case "java.lang.Byte": 
            case "short": 
            case "java.lang.Short": 
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": {
                return 0;
            }
            case "float": 
            case "java.lang.Float": 
            case "double": 
            case "java.lang.Double": {
                return 0.0;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return true;
            }
            case "void": 
            case "java.lang.Void": {
                return null;
            }
            case "java.lang.String": {
                return "";
            }
            case "java.lang.Object": {
                return Collections.emptyMap();
            }
            case "java.util.Date": {
                return System.currentTimeMillis();
            }
        }
        return Collections.emptyMap();
    }

    private static Object generateType(ServiceDefinition sd, String type) {
        TypeDefinition td = ServiceTestUtil.findTypeDefinition((ServiceDefinition)sd, (String)type);
        return ServiceTestUtil.generateType((ServiceDefinition)sd, (TypeDefinition)td);
    }

    private static Object generateType(ServiceDefinition sd, TypeDefinition td) {
        if (ServiceTestUtil.isPrimitiveType((TypeDefinition)td)) {
            return ServiceTestUtil.generatePrimitiveType((TypeDefinition)td);
        }
        if (ServiceTestUtil.isMap((TypeDefinition)td)) {
            return ServiceTestUtil.generateMapType((ServiceDefinition)sd, (TypeDefinition)td);
        }
        if (ServiceTestUtil.isArray((TypeDefinition)td)) {
            return ServiceTestUtil.generateArrayType((ServiceDefinition)sd, (TypeDefinition)td);
        }
        if (ServiceTestUtil.isCollection((TypeDefinition)td)) {
            return ServiceTestUtil.generateCollectionType((ServiceDefinition)sd, (TypeDefinition)td);
        }
        return ServiceTestUtil.generateComplexType((ServiceDefinition)sd, (TypeDefinition)td);
    }

    private static Object generateMapType(ServiceDefinition sd, TypeDefinition td) {
        String keyType = StringUtils.substringAfter((String)td.getType(), (String)"<");
        keyType = StringUtils.substringBefore((String)keyType, (String)",");
        keyType = StringUtils.strip((String)keyType);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Object key = ServiceTestUtil.generateType((ServiceDefinition)sd, (String)keyType);
        String valueType = StringUtils.substringAfter((String)td.getType(), (String)",");
        valueType = StringUtils.substringBefore((String)valueType, (String)">");
        valueType = StringUtils.isNotEmpty((CharSequence)(valueType = StringUtils.strip((String)valueType))) ? valueType : "java.lang.Object";
        Object value = ServiceTestUtil.generateType((ServiceDefinition)sd, (String)valueType);
        map.put(key, value);
        return map;
    }

    private static Object generateCollectionType(ServiceDefinition sd, TypeDefinition td) {
        String type = StringUtils.substringAfter((String)td.getType(), (String)"<");
        if (StringUtils.isEmpty((CharSequence)(type = StringUtils.substringBefore((String)type, (String)">")))) {
            return new Object[0];
        }
        return new Object[]{ServiceTestUtil.generateType((ServiceDefinition)sd, (String)type)};
    }

    private static Object generateArrayType(ServiceDefinition sd, TypeDefinition td) {
        String type = StringUtils.substringBeforeLast((String)td.getType(), (String)"[]");
        return new Object[]{ServiceTestUtil.generateType((ServiceDefinition)sd, (String)type)};
    }

    private static void generateEnclosedType(Map<String, Object> holder, String key, ServiceDefinition sd, TypeDefinition td) {
        if (td.getProperties() == null || td.getProperties().size() == 0 || ServiceTestUtil.isPrimitiveType((TypeDefinition)td)) {
            holder.put(key, ServiceTestUtil.generateType((ServiceDefinition)sd, (TypeDefinition)td));
        } else {
            HashMap enclosedMap = new HashMap();
            holder.put(key, enclosedMap);
            ServiceTestUtil.generateComplexType((ServiceDefinition)sd, (TypeDefinition)td, enclosedMap);
        }
    }
}

