/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.config;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.common.exception.ConfigurationException;
import org.apache.dubbo.admin.registry.config.GovernanceConfiguration;
import org.apache.dubbo.admin.registry.metadata.MetaDataCollector;
import org.apache.dubbo.admin.registry.metadata.impl.NoOpMetadataCollector;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
public class ConfigCenter {
    @Value(value="${admin.config-center:}")
    private String configCenter;
    @Value(value="${admin.registry.address:}")
    private String registryAddress;
    @Value(value="${admin.metadata-report.address:}")
    private String metadataAddress;
    @Value(value="${admin.metadata-report.cluster:false}")
    private boolean cluster;
    @Value(value="${admin.registry.group:dubbo}")
    private String registryGroup;
    @Value(value="${admin.config-center.group:dubbo}")
    private String configCenterGroup;
    @Value(value="${admin.metadata-report.group:dubbo}")
    private String metadataGroup;
    @Value(value="${admin.registry.namespace:dubbo}")
    private String registryNameSpace;
    @Value(value="${admin.config-center.namespace:dubbo}")
    private String configCenterGroupNameSpace;
    @Value(value="${admin.metadata-report.namespace:dubbo}")
    private String metadataGroupNameSpace;
    @Value(value="${admin.config-center.username:}")
    private String username;
    @Value(value="${admin.config-center.password:}")
    private String password;
    private static final Logger logger = LoggerFactory.getLogger(ConfigCenter.class);
    private URL configCenterUrl;
    private URL registryUrl;
    private URL metadataUrl;

    @Bean(value={"governanceConfiguration"})
    GovernanceConfiguration getDynamicConfiguration() {
        GovernanceConfiguration dynamicConfiguration = null;
        if (StringUtils.isNotEmpty((CharSequence)this.configCenter)) {
            this.configCenterUrl = this.formUrl(this.configCenter, this.configCenterGroup, this.configCenterGroupNameSpace, this.username, this.password);
            dynamicConfiguration = (GovernanceConfiguration)ExtensionLoader.getExtensionLoader(GovernanceConfiguration.class).getExtension(this.configCenterUrl.getProtocol());
            dynamicConfiguration.setUrl(this.configCenterUrl);
            dynamicConfiguration.init();
            String config = dynamicConfiguration.getConfig("config/dubbo/dubbo.properties");
            if (StringUtils.isNotEmpty((CharSequence)config)) {
                Arrays.stream(config.split("\n")).forEach(s -> {
                    if (s.startsWith("dubbo.registry.address")) {
                        String registryAddress = s.split("=")[1].trim();
                        this.registryUrl = this.formUrl(registryAddress, this.configCenterGroup, this.registryNameSpace, this.username, this.password);
                    } else if (s.startsWith("dubbo.metadata-report.address")) {
                        this.metadataUrl = this.formUrl(s.split("=")[1].trim(), this.configCenterGroup, this.metadataGroupNameSpace, this.username, this.password);
                    }
                });
            }
        }
        if (dynamicConfiguration == null) {
            if (StringUtils.isNotEmpty((CharSequence)this.registryAddress)) {
                this.registryUrl = this.formUrl(this.registryAddress, this.registryGroup, this.registryNameSpace, this.username, this.password);
                dynamicConfiguration = (GovernanceConfiguration)ExtensionLoader.getExtensionLoader(GovernanceConfiguration.class).getExtension(this.registryUrl.getProtocol());
                dynamicConfiguration.setUrl(this.registryUrl);
                dynamicConfiguration.init();
                logger.warn("you are using dubbo.registry.address, which is not recommend, please refer to: https://github.com/apache/incubator-dubbo-admin/wiki/Dubbo-Admin-configuration");
            } else {
                throw new ConfigurationException("Either config center or registry address is needed, please refer to https://github.com/apache/incubator-dubbo-admin/wiki/Dubbo-Admin-configuration");
            }
        }
        return dynamicConfiguration;
    }

    @Bean
    @DependsOn(value={"governanceConfiguration"})
    Registry getRegistry() {
        Registry registry = null;
        if (this.registryUrl == null) {
            if (StringUtils.isBlank((CharSequence)this.registryAddress)) {
                throw new ConfigurationException("Either config center or registry address is needed, please refer to https://github.com/apache/incubator-dubbo-admin/wiki/Dubbo-Admin-configuration");
            }
            this.registryUrl = this.formUrl(this.registryAddress, this.registryGroup, this.registryNameSpace, this.username, this.password);
        }
        RegistryFactory registryFactory = (RegistryFactory)ExtensionLoader.getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
        registry = registryFactory.getRegistry(this.registryUrl);
        return registry;
    }

    @Bean
    @DependsOn(value={"governanceConfiguration"})
    MetaDataCollector getMetadataCollector() {
        NoOpMetadataCollector metaDataCollector = new NoOpMetadataCollector();
        if (this.metadataUrl == null && StringUtils.isNotEmpty((CharSequence)this.metadataAddress)) {
            this.metadataUrl = this.formUrl(this.metadataAddress, this.metadataGroup, this.metadataGroupNameSpace, this.username, this.password);
            this.metadataUrl = this.metadataUrl.addParameter("cluster", this.cluster);
        }
        if (this.metadataUrl != null) {
            metaDataCollector = (MetaDataCollector)ExtensionLoader.getExtensionLoader(MetaDataCollector.class).getExtension(this.metadataUrl.getProtocol());
            metaDataCollector.setUrl(this.metadataUrl);
            metaDataCollector.init();
        } else {
            logger.warn("you are using dubbo.registry.address, which is not recommend, please refer to: https://github.com/apache/incubator-dubbo-admin/wiki/Dubbo-Admin-configuration");
        }
        return metaDataCollector;
    }

    private URL formUrl(String config, String group, String nameSpace, String username, String password) {
        URL url = URL.valueOf((String)config);
        if (StringUtils.isNotEmpty((CharSequence)group)) {
            url = url.addParameter("group", group);
        }
        if (StringUtils.isNotEmpty((CharSequence)nameSpace)) {
            url = url.addParameter("namespace", nameSpace);
        }
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            url = url.setUsername(username);
        }
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            url = url.setPassword(password);
        }
        return url;
    }
}

