/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.exception.ParamValidationException;
import org.apache.dubbo.admin.common.exception.ResourceNotFoundException;
import org.apache.dubbo.admin.common.exception.VersionValidationException;
import org.apache.dubbo.admin.model.dto.ConditionRouteDTO;
import org.apache.dubbo.admin.service.ProviderService;
import org.apache.dubbo.admin.service.RouteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}/rules/route/condition"})
public class ConditionRoutesController {
    private final RouteService routeService;
    private final ProviderService providerService;

    @Autowired
    public ConditionRoutesController(RouteService routeService, ProviderService providerService) {
        this.routeService = routeService;
        this.providerService = providerService;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public boolean createRule(@RequestBody ConditionRouteDTO routeDTO, @PathVariable String env) {
        String serviceName = routeDTO.getService();
        String app = routeDTO.getApplication();
        if (StringUtils.isEmpty((CharSequence)serviceName) && StringUtils.isEmpty((CharSequence)app)) {
            throw new ParamValidationException("serviceName and app is Empty!");
        }
        if (StringUtils.isNotEmpty((CharSequence)app) && this.providerService.findVersionInApplication(app).equals("2.6")) {
            throw new VersionValidationException("dubbo 2.6 does not support application scope routing rule");
        }
        this.routeService.createConditionRoute(routeDTO);
        return true;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public boolean updateRule(@PathVariable String id, @RequestBody ConditionRouteDTO newConditionRoute, @PathVariable String env) {
        ConditionRouteDTO oldConditionRoute = this.routeService.findConditionRoute(id = id.replace("*", "/"));
        if (oldConditionRoute == null) {
            throw new ResourceNotFoundException("can not find route rule for: " + id);
        }
        this.routeService.updateConditionRoute(newConditionRoute);
        return true;
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<ConditionRouteDTO> searchRoutes(@RequestParam(required=false) String application, @RequestParam(required=false) String service, @PathVariable String env) {
        ConditionRouteDTO conditionRoute = null;
        ArrayList<ConditionRouteDTO> result = new ArrayList<ConditionRouteDTO>();
        if (StringUtils.isNotBlank((CharSequence)application)) {
            conditionRoute = this.routeService.findConditionRoute(application);
        } else if (StringUtils.isNotBlank((CharSequence)service)) {
            conditionRoute = this.routeService.findConditionRoute(service);
        } else {
            throw new ParamValidationException("Either Service or application is required.");
        }
        if (conditionRoute != null && conditionRoute.getConditions() != null) {
            result.add(conditionRoute);
        }
        return result;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ConditionRouteDTO detailRoute(@PathVariable String id, @PathVariable String env) {
        ConditionRouteDTO conditionRoute = this.routeService.findConditionRoute(id = id.replace("*", "/"));
        if (conditionRoute == null || conditionRoute.getConditions() == null) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        return conditionRoute;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public boolean deleteRoute(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.routeService.deleteConditionRoute(id);
        return true;
    }

    @RequestMapping(value={"/enable/{id}"}, method={RequestMethod.PUT})
    public boolean enableRoute(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.routeService.enableConditionRoute(id);
        return true;
    }

    @RequestMapping(value={"/disable/{id}"}, method={RequestMethod.PUT})
    public boolean disableRoute(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.routeService.disableConditionRoute(id);
        return true;
    }
}

