/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.exception.ParamValidationException;
import org.apache.dubbo.admin.common.exception.ResourceNotFoundException;
import org.apache.dubbo.admin.common.exception.VersionValidationException;
import org.apache.dubbo.admin.model.dto.BalancingDTO;
import org.apache.dubbo.admin.service.OverrideService;
import org.apache.dubbo.admin.service.ProviderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}/rules/balancing"})
public class LoadBalanceController {
    private final OverrideService overrideService;
    private final ProviderService providerService;

    @Autowired
    public LoadBalanceController(OverrideService overrideService, ProviderService providerService) {
        this.overrideService = overrideService;
        this.providerService = providerService;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public boolean createLoadbalance(@RequestBody BalancingDTO balancingDTO, @PathVariable String env) throws ParamValidationException {
        if (StringUtils.isBlank((CharSequence)balancingDTO.getService()) && StringUtils.isBlank((CharSequence)balancingDTO.getApplication())) {
            throw new ParamValidationException("Either Service or application is required.");
        }
        String application = balancingDTO.getApplication();
        if (StringUtils.isNotEmpty((CharSequence)application) && this.providerService.findVersionInApplication(application).equals("2.6")) {
            throw new VersionValidationException("dubbo 2.6 does not support application scope load balancing config");
        }
        this.overrideService.saveBalance(balancingDTO);
        return true;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public boolean updateLoadbalance(@PathVariable String id, @RequestBody BalancingDTO balancingDTO, @PathVariable String env) throws ParamValidationException {
        if (id == null) {
            throw new ParamValidationException("Unknown ID!");
        }
        BalancingDTO balancing = this.overrideService.findBalance(id = id.replace("*", "/"));
        if (balancing == null) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        this.overrideService.saveBalance(balancingDTO);
        return true;
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<BalancingDTO> searchLoadbalances(@RequestParam(required=false) String service, @RequestParam(required=false) String application, @PathVariable String env) {
        if (StringUtils.isBlank((CharSequence)service) && StringUtils.isBlank((CharSequence)application)) {
            throw new ParamValidationException("Either service or application is required");
        }
        BalancingDTO balancingDTO = StringUtils.isNotBlank((CharSequence)application) ? this.overrideService.findBalance(application) : this.overrideService.findBalance(service);
        ArrayList<BalancingDTO> balancingDTOS = new ArrayList<BalancingDTO>();
        if (balancingDTO != null) {
            balancingDTOS.add(balancingDTO);
        }
        return balancingDTOS;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public BalancingDTO detailLoadBalance(@PathVariable String id, @PathVariable String env) throws ParamValidationException {
        BalancingDTO balancingDTO = this.overrideService.findBalance(id = id.replace("*", "/"));
        if (balancingDTO == null) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        return balancingDTO;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public boolean deleteLoadBalance(@PathVariable String id, @PathVariable String env) {
        if (id == null) {
            throw new IllegalArgumentException("Argument of id is null!");
        }
        id = id.replace("*", "/");
        this.overrideService.deleteBalance(id);
        return true;
    }
}

