/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.exception.ParamValidationException;
import org.apache.dubbo.admin.common.exception.ResourceNotFoundException;
import org.apache.dubbo.admin.model.dto.ConfigDTO;
import org.apache.dubbo.admin.service.ManagementService;
import org.apache.dubbo.admin.service.ProviderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}/manage"})
public class ManagementController {
    private final ManagementService managementService;
    private final ProviderService providerService;
    private static Pattern CLASS_NAME_PATTERN = Pattern.compile("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*");

    @Autowired
    public ManagementController(ManagementService managementService, ProviderService providerService) {
        this.managementService = managementService;
        this.providerService = providerService;
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public boolean createConfig(@RequestBody ConfigDTO config, @PathVariable String env) {
        this.managementService.setConfig(config);
        return true;
    }

    @RequestMapping(value={"/config/{key}"}, method={RequestMethod.PUT})
    public boolean updateConfig(@PathVariable String key, @RequestBody ConfigDTO configDTO, @PathVariable String env) {
        if (key == null) {
            throw new ParamValidationException("Unknown ID!");
        }
        String exitConfig = this.managementService.getConfig(key);
        if (exitConfig == null) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        return this.managementService.updateConfig(configDTO);
    }

    @RequestMapping(value={"/config/{key}"}, method={RequestMethod.GET})
    public List<ConfigDTO> getConfig(@PathVariable String key, @PathVariable String env) {
        Set<String> query = new HashSet<String>();
        ArrayList<ConfigDTO> configDTOs = new ArrayList<ConfigDTO>();
        if (key.equals("*")) {
            query = this.providerService.findApplications();
            query.add("global");
        } else {
            query.add(key);
        }
        for (String q : query) {
            String config = this.managementService.getConfig(q);
            if (config == null) continue;
            ConfigDTO configDTO = new ConfigDTO();
            configDTO.setKey(q);
            configDTO.setConfig(config);
            configDTO.setPath(this.managementService.getConfigPath(q));
            if ("global".equals(q)) {
                configDTO.setScope("global");
            } else if (CLASS_NAME_PATTERN.matcher(q).matches()) {
                configDTO.setScope("service");
            } else {
                configDTO.setScope("application");
            }
            configDTOs.add(configDTO);
        }
        return configDTOs;
    }

    @RequestMapping(value={"/config/{key}"}, method={RequestMethod.DELETE})
    public boolean deleteConfig(@PathVariable String key, @PathVariable String env) {
        return this.managementService.deleteConfig(key);
    }
}

