/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.util.Tool;
import org.apache.dubbo.admin.model.domain.Consumer;
import org.apache.dubbo.admin.model.domain.Provider;
import org.apache.dubbo.admin.model.dto.MetricDTO;
import org.apache.dubbo.admin.model.dto.RelationDTO;
import org.apache.dubbo.admin.service.ConsumerService;
import org.apache.dubbo.admin.service.MetricsService;
import org.apache.dubbo.admin.service.ProviderService;
import org.apache.dubbo.admin.service.impl.MetrcisCollectServiceImpl;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}/metrics"})
public class MetricsCollectController {
    private ProviderService providerService;
    private ConsumerService consumerService;
    private MetricsService metricsService;

    @Autowired
    public MetricsCollectController(ProviderService providerService, ConsumerService consumerService, MetricsService metricsService) {
        this.providerService = providerService;
        this.consumerService = consumerService;
        this.metricsService = metricsService;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String metricsCollect(@RequestParam String group, @PathVariable String env) {
        MetrcisCollectServiceImpl service = new MetrcisCollectServiceImpl();
        service.setUrl("dubbo://127.0.0.1:20880?scope=remote&cache=true");
        return service.invoke(group).toString();
    }

    @RequestMapping(value={"/relation"}, method={RequestMethod.GET})
    public RelationDTO getApplicationRelation() {
        return this.metricsService.getApplicationRelation();
    }

    private String getOnePortMessage(String group, String ip, String port, String protocol) {
        MetrcisCollectServiceImpl metrcisCollectService = new MetrcisCollectServiceImpl();
        metrcisCollectService.setUrl(protocol + "://" + ip + ":" + port + "?scope=remote&cache=true");
        String res = metrcisCollectService.invoke(group).toString();
        return res;
    }

    @RequestMapping(value={"/ipAddr"}, method={RequestMethod.GET})
    public List<MetricDTO> searchService(@RequestParam String ip, @RequestParam String group, @PathVariable String env) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        this.addMetricsConfigToMap(configMap, ip);
        if (configMap.size() <= 0) {
            configMap.put("20880", "dubbo");
        }
        ArrayList<MetricDTO> metricDTOS = new ArrayList<MetricDTO>();
        for (String port : configMap.keySet()) {
            String protocol = (String)configMap.get(port);
            String res = this.getOnePortMessage(group, ip, port, protocol);
            metricDTOS.addAll((Collection)new Gson().fromJson(res, new /* Unavailable Anonymous Inner Class!! */.getType()));
        }
        return metricDTOS;
    }

    protected void addMetricsConfigToMap(Map<String, String> configMap, String ip) {
        List providers = this.providerService.findByAddress(ip);
        if (providers.size() > 0) {
            Provider provider = (Provider)providers.get(0);
            String service = provider.getService();
            MetadataIdentifier providerIdentifier = new MetadataIdentifier(Tool.getInterface((String)service), Tool.getVersion((String)service), Tool.getGroup((String)service), "provider", provider.getApplication());
            String metaData = this.providerService.getProviderMetaData(providerIdentifier);
            FullServiceDefinition providerServiceDefinition = (FullServiceDefinition)new Gson().fromJson(metaData, FullServiceDefinition.class);
            Map parameters = providerServiceDefinition.getParameters();
            configMap.put((String)parameters.get("metrics.port"), (String)parameters.get("metrics.protocol"));
        } else {
            List consumers = this.consumerService.findByAddress(ip);
            if (consumers.size() > 0) {
                Consumer consumer = (Consumer)consumers.get(0);
                String service = consumer.getService();
                MetadataIdentifier consumerIdentifier = new MetadataIdentifier(Tool.getInterface((String)service), Tool.getVersion((String)service), Tool.getGroup((String)service), "consumer", consumer.getApplication());
                String metaData = this.consumerService.getConsumerMetadata(consumerIdentifier);
                Map consumerParameters = (Map)new Gson().fromJson(metaData, Map.class);
                configMap.put((String)consumerParameters.get("metrics.port"), (String)consumerParameters.get("metrics.protocol"));
            }
        }
    }
}

