/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.exception.ParamValidationException;
import org.apache.dubbo.admin.common.exception.ResourceNotFoundException;
import org.apache.dubbo.admin.common.exception.VersionValidationException;
import org.apache.dubbo.admin.model.dto.DynamicConfigDTO;
import org.apache.dubbo.admin.service.OverrideService;
import org.apache.dubbo.admin.service.ProviderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}/rules/override"})
public class OverridesController {
    private final OverrideService overrideService;
    private final ProviderService providerService;

    @Autowired
    public OverridesController(OverrideService overrideService, ProviderService providerService) {
        this.overrideService = overrideService;
        this.providerService = providerService;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public boolean createOverride(@RequestBody DynamicConfigDTO overrideDTO, @PathVariable String env) {
        String serviceName = overrideDTO.getService();
        String application = overrideDTO.getApplication();
        if (StringUtils.isEmpty((CharSequence)serviceName) && StringUtils.isEmpty((CharSequence)application)) {
            throw new ParamValidationException("serviceName and application are Empty!");
        }
        if (StringUtils.isNotEmpty((CharSequence)application) && this.providerService.findVersionInApplication(application).equals("2.6")) {
            throw new VersionValidationException("dubbo 2.6 does not support application scope dynamic config");
        }
        this.overrideService.saveOverride(overrideDTO);
        return true;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public boolean updateOverride(@PathVariable String id, @RequestBody DynamicConfigDTO overrideDTO, @PathVariable String env) {
        DynamicConfigDTO old = this.overrideService.findOverride(id = id.replace("*", "/"));
        if (old == null) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        this.overrideService.updateOverride(overrideDTO);
        return true;
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<DynamicConfigDTO> searchOverride(@RequestParam(required=false) String service, @RequestParam(required=false) String application, @PathVariable String env) {
        DynamicConfigDTO override = null;
        ArrayList<DynamicConfigDTO> result = new ArrayList<DynamicConfigDTO>();
        if (StringUtils.isNotBlank((CharSequence)service)) {
            override = this.overrideService.findOverride(service);
        } else if (StringUtils.isNotBlank((CharSequence)application)) {
            override = this.overrideService.findOverride(application);
        } else {
            throw new ParamValidationException("Either Service or application is required.");
        }
        if (override != null) {
            result.add(override);
        }
        return result;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public DynamicConfigDTO detailOverride(@PathVariable String id, @PathVariable String env) {
        DynamicConfigDTO override = this.overrideService.findOverride(id = id.replace("*", "/"));
        if (override == null) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        return override;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public boolean deleteOverride(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.overrideService.deleteOverride(id);
        return true;
    }

    @RequestMapping(value={"/enable/{id}"}, method={RequestMethod.PUT})
    public boolean enableRoute(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.overrideService.enableOverride(id);
        return true;
    }

    @RequestMapping(value={"/disable/{id}"}, method={RequestMethod.PUT})
    public boolean disableRoute(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.overrideService.disableOverride(id);
        return true;
    }
}

