/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import com.google.gson.Gson;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.util.Tool;
import org.apache.dubbo.admin.model.domain.Provider;
import org.apache.dubbo.admin.model.dto.ServiceDTO;
import org.apache.dubbo.admin.model.dto.ServiceDetailDTO;
import org.apache.dubbo.admin.service.ConsumerService;
import org.apache.dubbo.admin.service.ProviderService;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}"})
public class ServiceController {
    private final ProviderService providerService;
    private final ConsumerService consumerService;
    private final Gson gson;

    @Autowired
    public ServiceController(ProviderService providerService, ConsumerService consumerService) {
        this.providerService = providerService;
        this.consumerService = consumerService;
        this.gson = new Gson();
    }

    @RequestMapping(value={"/service"}, method={RequestMethod.GET})
    public Page<ServiceDTO> searchService(@RequestParam String pattern, @RequestParam String filter, @PathVariable String env, Pageable pageable) {
        Set serviceDTOS = this.providerService.getServiceDTOS(pattern, filter, env);
        int total = serviceDTOS.size();
        List content = serviceDTOS.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        PageImpl page = new PageImpl(content, pageable, (long)total);
        return page;
    }

    @RequestMapping(value={"/service/{service}"}, method={RequestMethod.GET})
    public ServiceDetailDTO serviceDetail(@PathVariable String service, @PathVariable String env) {
        service = service.replace("*", "/");
        String group = Tool.getGroup((String)service);
        String version = Tool.getVersion((String)service);
        String interfaze = Tool.getInterface((String)service);
        List providers = this.providerService.findByService(service);
        List consumers = this.consumerService.findByService(service);
        String application = null;
        if (providers != null && providers.size() > 0) {
            application = ((Provider)providers.get(0)).getApplication();
        }
        MetadataIdentifier identifier = new MetadataIdentifier(interfaze, version, group, "provider", application);
        String metadata = this.providerService.getProviderMetaData(identifier);
        ServiceDetailDTO serviceDetailDTO = new ServiceDetailDTO();
        serviceDetailDTO.setConsumers(consumers);
        serviceDetailDTO.setProviders(providers);
        if (metadata != null) {
            FullServiceDefinition serviceDefinition = (FullServiceDefinition)this.gson.fromJson(metadata, FullServiceDefinition.class);
            serviceDetailDTO.setMetadata(serviceDefinition);
        }
        serviceDetailDTO.setConsumers(consumers);
        serviceDetailDTO.setProviders(providers);
        serviceDetailDTO.setService(service);
        serviceDetailDTO.setApplication(application);
        return serviceDetailDTO;
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    public Set<String> allServices(@PathVariable String env) {
        return new HashSet<String>(this.providerService.findServices());
    }

    @RequestMapping(value={"/applications"}, method={RequestMethod.GET})
    public Set<String> allApplications(@PathVariable String env) {
        return this.providerService.findApplications();
    }
}

