/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.util.ConvertUtil;
import org.apache.dubbo.admin.common.util.ServiceTestUtil;
import org.apache.dubbo.admin.model.domain.MethodMetadata;
import org.apache.dubbo.admin.model.dto.ServiceTestDTO;
import org.apache.dubbo.admin.service.ProviderService;
import org.apache.dubbo.admin.service.impl.GenericServiceImpl;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}/test"})
public class ServiceTestController {
    private final GenericServiceImpl genericService;
    private final ProviderService providerService;

    public ServiceTestController(GenericServiceImpl genericService, ProviderService providerService) {
        this.genericService = genericService;
        this.providerService = providerService;
    }

    @RequestMapping(method={RequestMethod.POST})
    public Object test(@PathVariable String env, @RequestBody ServiceTestDTO serviceTestDTO) {
        return this.genericService.invoke(serviceTestDTO.getService(), serviceTestDTO.getMethod(), serviceTestDTO.getParameterTypes(), serviceTestDTO.getParams());
    }

    @RequestMapping(value={"/method"}, method={RequestMethod.GET})
    public MethodMetadata methodDetail(@PathVariable String env, @RequestParam String application, @RequestParam String service, @RequestParam String method) {
        Gson gson;
        FullServiceDefinition serviceDefinition;
        List methods;
        Map info = ConvertUtil.serviceName2Map((String)service);
        MetadataIdentifier identifier = new MetadataIdentifier((String)info.get("interface"), (String)info.get("version"), (String)info.get("group"), "provider", application);
        String metadata = this.providerService.getProviderMetaData(identifier);
        MethodMetadata methodMetadata = null;
        if (metadata != null && (methods = (serviceDefinition = (FullServiceDefinition)(gson = new Gson()).fromJson(metadata, FullServiceDefinition.class)).getMethods()) != null) {
            for (MethodDefinition m : methods) {
                if (!ServiceTestUtil.sameMethod((MethodDefinition)m, (String)method)) continue;
                methodMetadata = ServiceTestUtil.generateMethodMeta((FullServiceDefinition)serviceDefinition, (MethodDefinition)m);
                break;
            }
        }
        return methodMetadata;
    }
}

