/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.exception.ParamValidationException;
import org.apache.dubbo.admin.common.exception.ResourceNotFoundException;
import org.apache.dubbo.admin.common.exception.VersionValidationException;
import org.apache.dubbo.admin.model.dto.WeightDTO;
import org.apache.dubbo.admin.service.OverrideService;
import org.apache.dubbo.admin.service.ProviderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}/rules/weight"})
public class WeightController {
    private final OverrideService overrideService;
    private final ProviderService providerService;

    @Autowired
    public WeightController(OverrideService overrideService, ProviderService providerService) {
        this.overrideService = overrideService;
        this.providerService = providerService;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public boolean createWeight(@RequestBody WeightDTO weightDTO, @PathVariable String env) {
        if (StringUtils.isBlank((CharSequence)weightDTO.getService()) && StringUtils.isBlank((CharSequence)weightDTO.getApplication())) {
            throw new ParamValidationException("Either Service or application is required.");
        }
        String application = weightDTO.getApplication();
        if (StringUtils.isNotEmpty((CharSequence)application) && this.providerService.findVersionInApplication(application).equals("2.6")) {
            throw new VersionValidationException("dubbo 2.6 does not support application scope blackwhite list config");
        }
        this.overrideService.saveWeight(weightDTO);
        return true;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public boolean updateWeight(@PathVariable String id, @RequestBody WeightDTO weightDTO, @PathVariable String env) {
        if (id == null) {
            throw new ParamValidationException("Unknown ID!");
        }
        WeightDTO weight = this.overrideService.findWeight(id = id.replace("*", "/"));
        if (weight == null) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        this.overrideService.updateWeight(weightDTO);
        return true;
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<WeightDTO> searchWeight(@RequestParam(required=false) String service, @RequestParam(required=false) String application, @PathVariable String env) {
        if (StringUtils.isBlank((CharSequence)service) && StringUtils.isBlank((CharSequence)application)) {
            throw new ParamValidationException("Either service or application is required");
        }
        WeightDTO weightDTO = StringUtils.isNotBlank((CharSequence)application) ? this.overrideService.findWeight(application) : this.overrideService.findWeight(service);
        ArrayList<WeightDTO> weightDTOS = new ArrayList<WeightDTO>();
        if (weightDTO != null) {
            weightDTOS.add(weightDTO);
        }
        return weightDTOS;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public WeightDTO detailWeight(@PathVariable String id, @PathVariable String env) {
        WeightDTO weightDTO = this.overrideService.findWeight(id = id.replace("*", "/"));
        if (weightDTO == null) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        return weightDTO;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public boolean deleteWeight(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.overrideService.deleteWeight(id);
        return true;
    }
}

