/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.interceptor;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.controller.UserController;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AuthInterceptor
extends HandlerInterceptorAdapter {
    @Value(value="${admin.check.authority:true}")
    private boolean checkAuthority;
    @Value(value="${admin.check.sessionTimeoutMilli:3600000}")
    private long sessionTimeoutMilli;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod) || !this.checkAuthority) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Authority authority = method.getDeclaredAnnotation(Authority.class);
        if (null == authority) {
            authority = method.getDeclaringClass().getDeclaredAnnotation(Authority.class);
        }
        String authorization = request.getHeader("Authorization");
        if (null != authority && authority.needLogin()) {
            if (StringUtils.isEmpty((Object)authorization)) {
                AuthInterceptor.rejectedResponse((HttpServletResponse)response);
                return false;
            }
            UserController.User user = (UserController.User)UserController.tokenMap.get(authorization);
            if (null != user && System.currentTimeMillis() - user.getLastUpdateTime() <= this.sessionTimeoutMilli) {
                user.setLastUpdateTime(System.currentTimeMillis());
                return true;
            }
            AuthInterceptor.rejectedResponse((HttpServletResponse)response);
            return false;
        }
        return true;
    }

    private static void rejectedResponse(@NotNull HttpServletResponse response) {
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
    }
}

