/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.registry.config.impl;

import com.ctrip.framework.apollo.openapi.client.ApolloOpenApiClient;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import org.apache.dubbo.admin.registry.config.GovernanceConfiguration;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.SPI;
import org.springframework.beans.factory.annotation.Value;

@SPI(value="apollo")
public class ApolloConfiguration
implements GovernanceConfiguration {
    @Value(value="${admin.apollo.token}")
    private String token;
    @Value(value="${admin.apollo.cluster}")
    private String cluster;
    @Value(value="${admin.apollo.namespace}")
    private String namespace;
    @Value(value="${admin.apollo.env}")
    private String env;
    @Value(value="${admin.apollo.appId}")
    private String appId;
    private URL url;
    private ApolloOpenApiClient client;

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public void init() {
        this.client = ApolloOpenApiClient.newBuilder().withPortalUrl(this.url.getAddress()).withToken(this.token).build();
    }

    public String setConfig(String key, String value) {
        return this.setConfig(null, key, value);
    }

    public String getConfig(String key) {
        return this.getConfig(null, key);
    }

    public boolean deleteConfig(String key) {
        return this.deleteConfig(null, key);
    }

    public String setConfig(String group, String key, String value) {
        if (group == null) {
            group = this.namespace;
        }
        OpenItemDTO openItemDTO = new OpenItemDTO();
        openItemDTO.setKey(key);
        openItemDTO.setValue(value);
        this.client.createItem(this.appId, this.env, this.cluster, group, openItemDTO);
        return value;
    }

    public String getConfig(String group, String key) {
        OpenItemDTO openItemDTO;
        if (group == null) {
            group = this.namespace;
        }
        if ((openItemDTO = this.client.getItem(this.appId, this.env, this.cluster, group, key)) != null) {
            return openItemDTO.getValue();
        }
        return null;
    }

    public boolean deleteConfig(String group, String key) {
        if (group == null) {
            group = this.namespace;
        }
        this.client.removeItem(this.appId, this.env, this.cluster, group, key, "admin");
        return true;
    }

    public String getPath(String key) {
        return null;
    }

    public String getPath(String group, String key) {
        return null;
    }
}

