/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.registry.metadata.impl;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.dubbo.admin.registry.metadata.MetaDataCollector;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;

public class ZookeeperMetaDataCollector
implements MetaDataCollector {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperMetaDataCollector.class);
    private CuratorFramework client;
    private URL url;
    private String root;
    private static final String DEFAULT_ROOT = "dubbo";

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public void init() {
        String group = this.url.getParameter("group", DEFAULT_ROOT);
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.client = CuratorFrameworkFactory.newClient((String)this.url.getAddress(), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.client.start();
    }

    public String getProviderMetaData(MetadataIdentifier key) {
        return this.doGetMetadata(key);
    }

    public String getConsumerMetaData(MetadataIdentifier key) {
        return this.doGetMetadata(key);
    }

    private String getNodePath(MetadataIdentifier metadataIdentifier) {
        return this.toRootDir() + metadataIdentifier.getUniqueKey(KeyTypeEnum.PATH);
    }

    private String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }

    private String doGetMetadata(MetadataIdentifier identifier) {
        try {
            String path = this.getNodePath(identifier);
            if (this.client.checkExists().forPath(path) == null) {
                return null;
            }
            return new String((byte[])this.client.getData().forPath(path));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

