/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.admin.common.util.CoderUtil;
import org.apache.dubbo.admin.common.util.Tool;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RegistryServerSync
implements InitializingBean,
DisposableBean,
NotifyListener {
    private static final Logger logger = LoggerFactory.getLogger(RegistryServerSync.class);
    private static final URL SUBSCRIBE = new URL("admin", NetUtils.getLocalHost(), 0, "", new String[]{"interface", "*", "group", "*", "version", "*", "classifier", "*", "category", "providers,consumers,routers,configurators", "enabled", "*", "check", String.valueOf(false)});
    private static final AtomicLong ID = new AtomicLong();
    private final ConcurrentHashMap<String, String> URL_IDS_MAPPER = new ConcurrentHashMap();
    private final ConcurrentMap<String, ConcurrentMap<String, Map<String, URL>>> registryCache = new ConcurrentHashMap();
    @Autowired
    private Registry registry;

    public ConcurrentMap<String, ConcurrentMap<String, Map<String, URL>>> getRegistryCache() {
        return this.registryCache;
    }

    public void afterPropertiesSet() throws Exception {
        logger.info("Init Dubbo Admin Sync Cache...");
        this.registry.subscribe(SUBSCRIBE, (NotifyListener)this);
    }

    public void destroy() throws Exception {
        this.registry.unsubscribe(SUBSCRIBE, (NotifyListener)this);
    }

    public void notify(List<URL> urls) {
        Map services;
        String category;
        if (urls == null || urls.isEmpty()) {
            return;
        }
        HashMap categories = new HashMap();
        String interfaceName = null;
        for (URL uRL : urls) {
            String service;
            HashMap<Object, URL> ids;
            category = uRL.getParameter("category", "providers");
            if ("empty".equalsIgnoreCase(uRL.getProtocol())) {
                services = (ConcurrentMap)this.registryCache.get(category);
                if (services == null) continue;
                String group = uRL.getParameter("group");
                String version = uRL.getParameter("version");
                if (!"*".equals(group) && !"*".equals(version)) {
                    services.remove(uRL.getServiceKey());
                    continue;
                }
                for (Map.Entry serviceEntry : services.entrySet()) {
                    String service2 = (String)serviceEntry.getKey();
                    if (!Tool.getInterface((String)service2).equals(uRL.getServiceInterface()) || !"*".equals(group) && !StringUtils.isEquals((String)group, (String)Tool.getGroup((String)service2)) || !"*".equals(version) && !StringUtils.isEquals((String)version, (String)Tool.getVersion((String)service2))) continue;
                    services.remove(service2);
                }
                continue;
            }
            if (StringUtils.isEmpty(interfaceName)) {
                interfaceName = uRL.getServiceInterface();
            }
            if ((services = (Map)categories.get(category)) == null) {
                services = new HashMap();
                categories.put(category, services);
            }
            if ((ids = (HashMap<Object, URL>)services.get(service = uRL.getServiceKey())) == null) {
                ids = new HashMap<Object, URL>();
                services.put(service, ids);
            }
            if (this.URL_IDS_MAPPER.containsKey(uRL.toFullString())) {
                ids.put(this.URL_IDS_MAPPER.get(uRL.toFullString()), uRL);
                continue;
            }
            String md5 = CoderUtil.MD5_16bit((String)uRL.toFullString());
            ids.put(md5, uRL);
            this.URL_IDS_MAPPER.putIfAbsent(uRL.toFullString(), md5);
        }
        if (categories.size() == 0) {
            return;
        }
        for (Map.Entry entry : categories.entrySet()) {
            category = (String)entry.getKey();
            services = (ConcurrentMap)this.registryCache.get(category);
            if (services == null) {
                services = new ConcurrentHashMap();
                this.registryCache.put(category, services);
            } else {
                HashSet keys = new HashSet(services.keySet());
                for (String key : keys) {
                    if (!Tool.getInterface((String)key).equals(interfaceName) || ((Map)entry.getValue()).entrySet().contains(key)) continue;
                    services.remove(key);
                }
            }
            services.putAll((Map)entry.getValue());
        }
    }
}

