/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.service.impl;

import org.apache.dubbo.admin.model.dto.ConfigDTO;
import org.apache.dubbo.admin.service.ManagementService;
import org.apache.dubbo.admin.service.impl.AbstractService;
import org.springframework.stereotype.Component;

@Component
public class ManagementServiceImpl
extends AbstractService
implements ManagementService {
    public void setConfig(ConfigDTO config) {
        if ("global".equals(config.getKey())) {
            this.dynamicConfiguration.setConfig("config/dubbo/dubbo.properties", config.getConfig());
        } else {
            this.dynamicConfiguration.setConfig(this.getPath(config.getKey()), config.getConfig());
        }
    }

    public String getConfig(String key) {
        if ("global".equals(key)) {
            return this.dynamicConfiguration.getConfig("config/dubbo/dubbo.properties");
        }
        return this.dynamicConfiguration.getConfig(this.getPath(key));
    }

    public String getConfigPath(String key) {
        if ("global".equals(key)) {
            return this.dynamicConfiguration.getPath("config/dubbo/dubbo.properties");
        }
        return this.dynamicConfiguration.getPath(this.getPath(key));
    }

    public boolean updateConfig(ConfigDTO configDTO) {
        String key = configDTO.getKey();
        if ("global".equals(key)) {
            this.dynamicConfiguration.setConfig("config/dubbo/dubbo.properties", configDTO.getConfig());
        } else {
            this.dynamicConfiguration.setConfig(this.getPath(key), configDTO.getConfig());
        }
        return true;
    }

    public boolean deleteConfig(String key) {
        if ("global".equals(key)) {
            this.dynamicConfiguration.deleteConfig("config/dubbo/dubbo.properties");
        } else {
            this.dynamicConfiguration.deleteConfig(this.getPath(key));
        }
        return true;
    }

    private String getPath(String key) {
        return "config/dubbo/" + key + "/" + "dubbo.properties";
    }
}

